/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import java.util.HashMap;
import java.util.Map;

public enum SSLConfigValue {
    NONE("None", "0"),
    SERVERAUTH("ServerAuth", "20"),
    CLIENTAUTH("ClientAuth", "40"),
    MUTUALAUTH("MutualAuth", "60");

    private String name;
    private String iiopValue;
    private static Map<String, SSLConfigValue> MAP;

    private SSLConfigValue(String name, String iiopValue) {
        this.name = name;
        this.iiopValue = iiopValue;
    }

    public String getIIOPValue() {
        return this.iiopValue;
    }

    public static SSLConfigValue fromValue(String value) {
        return MAP.get(value);
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, SSLConfigValue> map = new HashMap<String, SSLConfigValue>();
        for (SSLConfigValue configValue : SSLConfigValue.values()) {
            map.put(configValue.getIIOPValue(), configValue);
        }
        MAP = map;
    }
}

