/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.wagon.shared;

import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpGet;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpHead;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpPut;
import org.apache.maven.wagon.providers.http.httpclient.client.methods.HttpUriRequest;
import org.apache.maven.wagon.providers.http.wagon.shared.ConfigurationUtils;
import org.apache.maven.wagon.providers.http.wagon.shared.HttpMethodConfiguration;

public class HttpConfiguration {
    private static final HttpMethodConfiguration DEFAULT_PUT = new HttpMethodConfiguration().addParam("http.protocol.expect-continue", "%b,true");
    private HttpMethodConfiguration all;
    private HttpMethodConfiguration get;
    private HttpMethodConfiguration put;
    private HttpMethodConfiguration head;

    public HttpMethodConfiguration getAll() {
        return this.all;
    }

    public HttpConfiguration setAll(HttpMethodConfiguration all) {
        this.all = all;
        return this;
    }

    public HttpMethodConfiguration getGet() {
        return this.get;
    }

    public HttpConfiguration setGet(HttpMethodConfiguration get) {
        this.get = get;
        return this;
    }

    public HttpMethodConfiguration getPut() {
        return this.put;
    }

    public HttpConfiguration setPut(HttpMethodConfiguration put) {
        this.put = put;
        return this;
    }

    public HttpMethodConfiguration getHead() {
        return this.head;
    }

    public HttpConfiguration setHead(HttpMethodConfiguration head) {
        this.head = head;
        return this;
    }

    public HttpMethodConfiguration getMethodConfiguration(HttpUriRequest method) {
        if (method instanceof HttpGet) {
            return ConfigurationUtils.merge(this.all, this.get);
        }
        if (method instanceof HttpPut) {
            return ConfigurationUtils.merge(DEFAULT_PUT, this.all, this.put);
        }
        if (method instanceof HttpHead) {
            return ConfigurationUtils.merge(this.all, this.head);
        }
        return this.all;
    }
}

