/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.CaseParameterCorrector;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.ElementAttributeMarshaller;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.PropertyAttributeMarshaller;
import org.jboss.as.logging.PropertyObjectTypeAttributeDefinition;
import org.jboss.as.logging.capabilities.Capabilities;
import org.jboss.as.logging.correctors.FileCorrector;
import org.jboss.as.logging.resolvers.FileResolver;
import org.jboss.as.logging.resolvers.LevelResolver;
import org.jboss.as.logging.validators.FileValidator;
import org.jboss.as.logging.validators.LogLevelValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.Level;

public interface CommonAttributes {
    public static final PropertyAttributeDefinition APPEND = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("append", ModelType.BOOLEAN, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).setDefaultValue(ModelNode.TRUE)).build();
    public static final PropertyAttributeDefinition AUTOFLUSH = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("autoflush", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setPropertyName("autoFlush").build();
    public static final SimpleAttributeDefinition CLASS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"class", (ModelType)ModelType.STRING).setAllowExpression(false)).setRestartAllServices()).build();
    public static final PropertyAttributeDefinition ENABLED = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("enabled", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    public static final PropertyAttributeDefinition ENCODING = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("encoding", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.VALUE_ATTRIBUTE_MARSHALLER)).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)PathResourceDefinition.RELATIVE_TO).setCapabilityReference("org.wildfly.management.path")).build();
    public static final PropertyObjectTypeAttributeDefinition FILE = ((PropertyObjectTypeAttributeDefinition.Builder)((PropertyObjectTypeAttributeDefinition.Builder)((PropertyObjectTypeAttributeDefinition.Builder)((PropertyObjectTypeAttributeDefinition.Builder)((PropertyObjectTypeAttributeDefinition.Builder)PropertyObjectTypeAttributeDefinition.Builder.of("file", new AttributeDefinition[]{RELATIVE_TO, PathResourceDefinition.PATH}).setAllowExpression(false)).setRequired(true)).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                ModelNode file = resourceModel.get(attribute.getName());
                RELATIVE_TO.marshallAsAttribute(file, marshallDefault, writer);
                PathResourceDefinition.PATH.marshallAsAttribute(file, marshallDefault, writer);
                writer.writeEndElement();
            }
        }
    })).setCorrector(FileCorrector.INSTANCE)).setPropertyName("fileName").setResolver(FileResolver.INSTANCE).setValidator((ParameterValidator)new FileValidator())).build();
    public static final SimpleAttributeDefinition HANDLER_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)true).setCapabilityReference(Capabilities.HANDLER_REFERENCE_RECORDER)).build();
    public static final PropertyAttributeDefinition LEVEL = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("level", ModelType.STRING, true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)ElementAttributeMarshaller.NAME_ATTRIBUTE_MARSHALLER)).setCorrector(CaseParameterCorrector.TO_UPPER)).setDefaultValue(new ModelNode(Level.ALL.getName()))).setResolver(LevelResolver.INSTANCE).setValidator((ParameterValidator)new LogLevelValidator(true))).build();
    public static final String LOGGING_PROFILE = "logging-profile";
    public static final String LOGGING_PROFILES = "logging-profiles";
    public static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING).setAllowExpression(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0))).setResourceOnly()).build();
    public static final SimpleMapAttributeDefinition PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("properties", true).setAllowExpression(true)).setAttributeMarshaller((AttributeMarshaller)PropertyAttributeMarshaller.INSTANCE)).build();
    public static final String ROOT_LOGGER_NAME = "";
    public static final SimpleAttributeDefinition ACCEPT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"accept", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false)).setDefaultValue(ModelNode.TRUE)).build();
    public static final SimpleAttributeDefinition CHANGE_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"change-level", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).setCorrector(CaseParameterCorrector.TO_UPPER)).setValidator((ParameterValidator)new LogLevelValidator(true))).build();
    public static final SimpleAttributeDefinition DENY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"deny", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false)).setDefaultValue(ModelNode.TRUE)).build();
    public static final SimpleAttributeDefinition FILTER_PATTERN = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"pattern", (ModelType)ModelType.STRING).setAllowExpression(false)).build();
    public static final SimpleAttributeDefinition MATCH = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"match", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).build();
    public static final SimpleAttributeDefinition MAX_INCLUSIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-inclusive", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false)).setDefaultValue(ModelNode.TRUE)).build();
    public static final SimpleAttributeDefinition MAX_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-level", (ModelType)ModelType.STRING).setAllowExpression(false)).setCorrector(CaseParameterCorrector.TO_UPPER)).setValidator((ParameterValidator)new LogLevelValidator(true))).build();
    public static final SimpleAttributeDefinition MIN_INCLUSIVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-inclusive", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false)).setDefaultValue(ModelNode.TRUE)).build();
    public static final SimpleAttributeDefinition MIN_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-level", (ModelType)ModelType.STRING).setAllowExpression(false)).setCorrector(CaseParameterCorrector.TO_UPPER)).setValidator((ParameterValidator)new LogLevelValidator(true))).build();
    public static final SimpleAttributeDefinition NEW_LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"new-level", (ModelType)ModelType.STRING).setAllowExpression(false)).setCorrector(CaseParameterCorrector.TO_UPPER)).setValidator((ParameterValidator)new LogLevelValidator(true))).build();
    public static final SimpleAttributeDefinition REPLACEMENT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"replacement", (ModelType)ModelType.STRING).setAllowExpression(false)).build();
    public static final SimpleAttributeDefinition REPLACE_ALL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"replace-all", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(false)).setDefaultValue(ModelNode.TRUE)).build();
    public static final ObjectTypeAttributeDefinition LEVEL_RANGE_LEGACY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"level-range", (AttributeDefinition[])new AttributeDefinition[]{MIN_LEVEL, MIN_INCLUSIVE, MAX_LEVEL, MAX_INCLUSIVE}).setAllowExpression(false)).setRequired(false)).setValidator((ParameterValidator)new ObjectTypeValidator(false, new AttributeDefinition[]{MIN_LEVEL, MIN_INCLUSIVE, MAX_LEVEL, MAX_INCLUSIVE}){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            AttributeDefinition[] allowedValues;
            super.validateParameter(parameterName, value);
            ModelNode clonedValue = value.clone();
            for (AttributeDefinition valueType : allowedValues = new AttributeDefinition[]{MIN_LEVEL, MIN_INCLUSIVE, MAX_LEVEL, MAX_INCLUSIVE}) {
                ModelNode syntheticValue = clonedValue.has(valueType.getName()) ? clonedValue.get(valueType.getName()) : (valueType.getDefaultValue() != null ? valueType.getDefaultValue() : new ModelNode());
                valueType.getValidator().validateParameter(valueType.getName(), syntheticValue);
            }
        }
    })).build();
    public static final ObjectTypeAttributeDefinition REPLACE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"replace", (AttributeDefinition[])new AttributeDefinition[]{FILTER_PATTERN, REPLACEMENT, REPLACE_ALL}).setAllowExpression(false)).setRequired(false)).setValidator((ParameterValidator)new ObjectTypeValidator(false, new AttributeDefinition[]{FILTER_PATTERN, REPLACEMENT, REPLACE_ALL}){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            AttributeDefinition[] allowedValues;
            super.validateParameter(parameterName, value);
            ModelNode clonedValue = value.clone();
            for (AttributeDefinition valueType : allowedValues = new AttributeDefinition[]{FILTER_PATTERN, REPLACEMENT, REPLACE_ALL}) {
                ModelNode syntheticValue = clonedValue.has(valueType.getName()) ? clonedValue.get(valueType.getName()) : (valueType.getDefaultValue() != null ? valueType.getDefaultValue() : new ModelNode());
                valueType.getValidator().validateParameter(valueType.getName(), syntheticValue);
            }
        }
    })).build();
    public static final ObjectTypeAttributeDefinition NOT = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"not", (AttributeDefinition[])new AttributeDefinition[]{ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, REPLACE}).setAllowExpression(false)).setRequired(false)).build();
    public static final ObjectTypeAttributeDefinition ALL = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"all", (AttributeDefinition[])new AttributeDefinition[]{ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, NOT, REPLACE}).setAllowExpression(false)).setRequired(false)).build();
    public static final ObjectTypeAttributeDefinition ANY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"any", (AttributeDefinition[])new AttributeDefinition[]{ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, NOT, REPLACE}).setAllowExpression(false)).setRequired(false)).build();
    public static final ObjectTypeAttributeDefinition FILTER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"filter", (AttributeDefinition[])new AttributeDefinition[]{ALL, ANY, ACCEPT, CHANGE_LEVEL, DENY, LEVEL, LEVEL_RANGE_LEGACY, MATCH, NOT, REPLACE}).setAllowExpression(false)).addAlternatives(new String[]{"filter-spec"})).setDeprecated(ModelVersion.create((int)1, (int)2, (int)0))).setRequired(false)).addFlag(AttributeAccess.Flag.ALIAS)).build();
    public static final String ADD_HANDLER_OPERATION_NAME = "add-handler";
    public static final String REMOVE_HANDLER_OPERATION_NAME = "remove-handler";
}

