/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachableDependency;
import org.jboss.as.server.deployment.AttachedDependency;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentPhaseContextImpl;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitPhaseDependency;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ListAttachmentKey;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.RegisteredDeploymentUnitProcessor;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.DelegatingServiceRegistry;
import org.jboss.msc.service.DelegatingServiceTarget;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

final class DeploymentUnitPhaseService<T>
implements org.jboss.msc.service.Service<T> {
    private final InjectedValue<DeployerChains> deployerChainsInjector = new InjectedValue();
    private final DeploymentUnit deploymentUnit;
    private final Phase phase;
    private final AttachmentKey<T> valueKey;
    private final List<AttachedDependency> injectedAttachedDependencies = new ArrayList<AttachedDependency>();
    private final AtomicBoolean runOnce = new AtomicBoolean();

    private DeploymentUnitPhaseService(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        this.deploymentUnit = deploymentUnit;
        this.phase = phase;
        this.valueKey = valueKey;
    }

    private static <T> DeploymentUnitPhaseService<T> create(DeploymentUnit deploymentUnit, Phase phase, AttachmentKey<T> valueKey) {
        return new DeploymentUnitPhaseService<T>(deploymentUnit, phase, valueKey);
    }

    static DeploymentUnitPhaseService<?> create(DeploymentUnit deploymentUnit, Phase phase) {
        return DeploymentUnitPhaseService.create(deploymentUnit, phase, phase.getPhaseKey());
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void start(StartContext context) throws StartException {
        Set<Object> registeredSubSystems;
        if (this.runOnce.get()) {
            ServerLogger.DEPLOYMENT_LOGGER.deploymentRestartDetected(this.deploymentUnit.getName());
            ServiceName serviceName = this.deploymentUnit.getParent() == null ? this.deploymentUnit.getServiceName() : this.deploymentUnit.getParent().getServiceName();
            ServiceController controller = context.getController().getServiceContainer().getRequiredService(serviceName);
            controller.addListener(new LifecycleListener(){

                public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                    if (event == LifecycleEvent.DOWN) {
                        controller.setMode(ServiceController.Mode.ACTIVE);
                        controller.removeListener((LifecycleListener)this);
                    }
                }
            });
            controller.setMode(ServiceController.Mode.NEVER);
            return;
        }
        this.runOnce.set(true);
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        DeploymentUnit deploymentUnit = this.deploymentUnit;
        List<RegisteredDeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<RegisteredDeploymentUnitProcessor> iterator = list.listIterator();
        ServiceContainer container = context.getController().getServiceContainer();
        DeploymentUnitServiceTarget serviceTarget = new DeploymentUnitServiceTarget(context.getChildTarget().subTarget(), deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT));
        DeploymentUnit parent = deploymentUnit.getParent();
        LinkedList<DeploymentUnitPhaseDependency> dependencies = new LinkedList<DeploymentUnitPhaseDependency>();
        DeploymentPhaseContextImpl processorContext = new DeploymentPhaseContextImpl(serviceTarget, (ServiceRegistry)new DelegatingServiceRegistry((ServiceRegistry)container), dependencies, deploymentUnit, this.phase);
        for (AttachedDependency attachedDependency : this.injectedAttachedDependencies) {
            void var13_22;
            if (attachedDependency.isDeploymentUnit()) {
                DeploymentUnit deploymentUnit2 = deploymentUnit;
            } else {
                DeploymentPhaseContextImpl deploymentPhaseContextImpl = processorContext;
            }
            if (attachedDependency.getAttachmentKey() instanceof ListAttachmentKey) {
                var13_22.addToAttachmentList(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
                continue;
            }
            var13_22.putAttachment(attachedDependency.getAttachmentKey(), attachedDependency.getValue().getValue());
        }
        if (this.phase == Phase.STRUCTURE) {
            registeredSubSystems = new HashSet();
            deploymentUnit.putAttachment(Attachments.REGISTERED_SUBSYSTEMS, registeredSubSystems);
        } else {
            registeredSubSystems = deploymentUnit.getAttachment(Attachments.REGISTERED_SUBSYSTEMS);
        }
        for (RegisteredDeploymentUnitProcessor registeredDeploymentUnitProcessor : list) {
            registeredSubSystems.add(registeredDeploymentUnitProcessor.getSubsystemName());
        }
        if (this.phase == Phase.CLEANUP) {
            ModuleSpecification moduleSpecification;
            Set<ModuleIdentifier> nonexsistentExcludedDependencies;
            void var12_18;
            Set<String> set = deploymentUnit.getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
            if (set == null && deploymentUnit.getParent() != null) {
                Set<String> set2 = deploymentUnit.getParent().getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
            }
            if (var12_18 != null) {
                for (String sub : var12_18) {
                    if (registeredSubSystems.contains(sub)) continue;
                    ServerLogger.DEPLOYMENT_LOGGER.excludedSubSystemsNotExist(sub);
                }
            }
            if (!(nonexsistentExcludedDependencies = (moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION)).getNonexistentExcludedDependencies()).isEmpty()) {
                for (ModuleIdentifier moduleIdentifier : nonexsistentExcludedDependencies) {
                    ServerLogger.DEPLOYMENT_LOGGER.excludedDependenciesNotExist(moduleIdentifier.getName());
                }
            }
        }
        while (iterator.hasNext()) {
            RegisteredDeploymentUnitProcessor registeredDeploymentUnitProcessor = iterator.next();
            try {
                if (!DeploymentUnitPhaseService.shouldRun(deploymentUnit, registeredDeploymentUnitProcessor)) continue;
                registeredDeploymentUnitProcessor.getProcessor().deploy(processorContext);
            }
            catch (Throwable throwable) {
                while (iterator.hasPrevious()) {
                    RegisteredDeploymentUnitProcessor prev = iterator.previous();
                    DeploymentUnitPhaseService.safeUndeploy(deploymentUnit, this.phase, prev);
                }
                throw ServerLogger.ROOT_LOGGER.deploymentPhaseFailed(this.phase, deploymentUnit, throwable);
            }
        }
        Phase phase = this.phase.next();
        if (phase != null) {
            List nextPhaseAttachableDeps;
            ServiceName serviceName = DeploymentUtils.getDeploymentUnitPhaseServiceName(deploymentUnit, phase);
            DeploymentUnitPhaseService<?> phaseService = DeploymentUnitPhaseService.create(deploymentUnit, phase);
            ServiceBuilder phaseServiceBuilder = serviceTarget.addService(serviceName, phaseService);
            for (DeploymentUnitPhaseDependency dependency : dependencies) {
                dependency.register(phaseServiceBuilder);
            }
            phaseServiceBuilder.addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector());
            for (Object providedValue : context.getController().provides()) {
                phaseServiceBuilder.requires((ServiceName)providedValue);
            }
            List list2 = processorContext.getAttachment(Attachments.NEXT_PHASE_DEPS);
            if (list2 != null) {
                for (Object nextPhaseDep : list2) {
                    phaseServiceBuilder.requires((ServiceName)nextPhaseDep);
                }
            }
            if ((nextPhaseAttachableDeps = (List)processorContext.getAttachment(Attachments.NEXT_PHASE_ATTACHABLE_DEPS)) != null) {
                for (AttachableDependency attachableDep : nextPhaseAttachableDeps) {
                    AttachedDependency result = new AttachedDependency(attachableDep.getAttachmentKey(), attachableDep.isDeploymentUnit());
                    phaseServiceBuilder.addDependency(attachableDep.getServiceName(), Object.class, result.getValue());
                    phaseService.injectedAttachedDependencies.add(result);
                }
            }
            if (parent != null) {
                phaseServiceBuilder.requires(Services.deploymentUnitName(parent.getName(), phase));
            }
            List<DeploymentUnit> subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit du : subDeployments) {
                phaseServiceBuilder.requires(du.getServiceName().append(new String[]{this.phase.name()}));
            }
            phaseServiceBuilder.install();
        }
    }

    public synchronized void stop(StopContext context) {
        DeploymentUnit deploymentUnitContext = this.deploymentUnit;
        DeployerChains chains = (DeployerChains)this.deployerChainsInjector.getValue();
        List<RegisteredDeploymentUnitProcessor> list = chains.getChain(this.phase);
        ListIterator<RegisteredDeploymentUnitProcessor> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            RegisteredDeploymentUnitProcessor prev = iterator.previous();
            DeploymentUnitPhaseService.safeUndeploy(deploymentUnitContext, this.phase, prev);
        }
    }

    private static void safeUndeploy(DeploymentUnit deploymentUnit, Phase phase, RegisteredDeploymentUnitProcessor prev) {
        try {
            if (DeploymentUnitPhaseService.shouldRun(deploymentUnit, prev)) {
                prev.getProcessor().undeploy(deploymentUnit);
            }
        }
        catch (Throwable t) {
            ServerLogger.DEPLOYMENT_LOGGER.caughtExceptionUndeploying(t, prev.getProcessor(), phase, deploymentUnit);
        }
    }

    public synchronized T getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit.getAttachment(this.valueKey);
    }

    InjectedValue<DeployerChains> getDeployerChainsInjector() {
        return this.deployerChainsInjector;
    }

    private static boolean shouldRun(DeploymentUnit unit, RegisteredDeploymentUnitProcessor deployer) {
        Set<String> shouldNotRun = unit.getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
        if (shouldNotRun == null) {
            if (unit.getParent() != null) {
                shouldNotRun = unit.getParent().getAttachment(Attachments.EXCLUDED_SUBSYSTEMS);
            }
            if (shouldNotRun == null) {
                return true;
            }
        }
        return !shouldNotRun.contains(deployer.getSubsystemName());
    }

    static class DeploymentUnitServiceBuilder<T>
    extends DelegatingServiceBuilder<T>
    implements RequirementServiceBuilder<T> {
        private final CapabilityServiceSupport support;

        DeploymentUnitServiceBuilder(ServiceBuilder<T> builder, CapabilityServiceSupport support) {
            super(builder);
            this.support = support;
        }

        public RequirementServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
            super.setInitialMode(mode);
            return this;
        }

        public RequirementServiceBuilder<T> setInstance(Service service) {
            super.setInstance(service);
            return this;
        }

        public RequirementServiceBuilder<T> addListener(LifecycleListener listener) {
            super.addListener(listener);
            return this;
        }

        public <V> Supplier<V> requiresCapability(String capabilityName, Class<V> dependencyType, String ... referenceNames) {
            return super.requires(this.support.getCapabilityServiceName(capabilityName, referenceNames));
        }
    }

    static class DeploymentUnitServiceTarget
    extends DelegatingServiceTarget
    implements RequirementServiceTarget {
        private final CapabilityServiceSupport support;

        DeploymentUnitServiceTarget(ServiceTarget target, CapabilityServiceSupport support) {
            super(target);
            this.support = support;
        }

        public RequirementServiceTarget addListener(LifecycleListener listener) {
            super.addListener(listener);
            return this;
        }

        public RequirementServiceTarget removeListener(LifecycleListener listener) {
            super.removeListener(listener);
            return this;
        }

        public RequirementServiceTarget subTarget() {
            return new DeploymentUnitServiceTarget(super.subTarget(), this.support);
        }

        public RequirementServiceBuilder<?> addService() {
            return new DeploymentUnitServiceBuilder(super.addService(), this.support);
        }
    }
}

