/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.spring.i18n.LogMessages;
import org.jboss.resteasy.plugins.spring.i18n.Messages;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.springmvc.RequestUtil;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

public class ResteasyHandlerMapping
implements HandlerMapping,
Ordered,
InitializingBean {
    private int order = Integer.MAX_VALUE;
    private SynchronousDispatcher dispatcher;
    private String prefix = "";
    private HandlerInterceptor[] interceptors;
    private boolean throwNotFound = false;

    public ResteasyHandlerMapping(ResteasyDeployment deployment) {
        this.dispatcher = (SynchronousDispatcher)deployment.getDispatcher();
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public HandlerInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(HandlerInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        ResteasyRequestWrapper requestWrapper = RequestUtil.getRequestWrapper(request, request.getMethod(), this.prefix);
        try {
            HttpRequest httpRequest = requestWrapper.getHttpRequest();
            if (!httpRequest.isInitial()) {
                String message = Messages.MESSAGES.pathNotInitialRequest(httpRequest.getUri().getPath());
                LogMessages.LOGGER.error(message);
                requestWrapper.setError(500, message);
            } else {
                Response response = this.dispatcher.preprocess(httpRequest);
                if (response != null) {
                    requestWrapper.setAbortedResponse(response);
                } else {
                    requestWrapper.setInvoker(this.getInvoker(httpRequest));
                }
            }
            return new HandlerExecutionChain((Object)requestWrapper, this.interceptors);
        }
        catch (NotFoundException e) {
            if (this.throwNotFound) {
                throw e;
            }
            LogMessages.LOGGER.error(Messages.MESSAGES.resourceNotFound(e.getMessage()), e);
        }
        catch (NotAcceptableException na) {
            requestWrapper.setError(406, Messages.MESSAGES.requestedMediaNotAcceptable());
            return new HandlerExecutionChain((Object)requestWrapper, this.interceptors);
        }
        catch (NotAllowedException na) {
            requestWrapper.setError(405, Messages.MESSAGES.notAllowed());
            return new HandlerExecutionChain((Object)requestWrapper, this.interceptors);
        }
        catch (NotSupportedException nse) {
            requestWrapper.setError(415, Messages.MESSAGES.notSupported());
            return new HandlerExecutionChain((Object)requestWrapper, this.interceptors);
        }
        catch (Failure e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.resourceFailure(e.getMessage()), e);
            throw e;
        }
        return null;
    }

    private ResourceInvoker getInvoker(HttpRequest httpRequest) {
        if (this.dispatcher != null) {
            return this.dispatcher.getInvoker(httpRequest);
        }
        return null;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isThrowNotFound() {
        return this.throwNotFound;
    }

    public void setThrowNotFound(boolean throwNotFound) {
        this.throwNotFound = throwNotFound;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.throwNotFound && this.order == Integer.MAX_VALUE) {
            LogMessages.LOGGER.info(Messages.MESSAGES.resteasyHandlerMappingHasDefaultOrder());
        }
    }
}

