/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.time.Duration;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.remoting.transport.Address;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.expiration.ExpirationMetaData;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.affinity.AffinityIdentifierFactory;
import org.wildfly.clustering.ee.infinispan.expiration.ScheduleWithExpirationMetaDataCommandFactory;
import org.wildfly.clustering.ee.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleLocalEntriesTask;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;
import org.wildfly.clustering.ejb.bean.Bean;
import org.wildfly.clustering.ejb.bean.BeanExpirationConfiguration;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.bean.BeanManager;
import org.wildfly.clustering.ejb.cache.bean.BeanFactory;
import org.wildfly.clustering.ejb.cache.bean.MutableBean;
import org.wildfly.clustering.ejb.cache.bean.OnCloseBean;
import org.wildfly.clustering.ejb.infinispan.bean.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataFilter;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.distribution.SimpleLocality;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.group.Group;

public class InfinispanBeanManager<K, V extends BeanInstance<K>, M>
implements BeanManager<K, V, TransactionBatch> {
    private final Cache<Key<K>, Object> cache;
    private final CacheProperties properties;
    private final BeanFactory<K, V, M> beanFactory;
    private final IdentifierFactory<K> identifierFactory;
    private final CommandDispatcherFactory dispatcherFactory;
    private final BeanExpirationConfiguration<K, V> expiration;
    private final Batcher<TransactionBatch> batcher;
    private final Predicate<Map.Entry<? super Key<K>, ? super Object>> filter;
    private final Function<Key<K>, Node> primaryOwnerLocator;
    private final Affinity strongAffinity;
    private volatile Scheduler<K, ExpirationMetaData> scheduler;
    private volatile ListenerRegistration schedulerListenerRegistration;
    private volatile UnaryOperator<Bean<K, V>> transformer;

    public InfinispanBeanManager(InfinispanBeanManagerConfiguration<K, V, M> configuration) {
        this.beanFactory = configuration.getBeanFactory();
        this.cache = configuration.getCache();
        this.properties = configuration.getCacheProperties();
        this.batcher = new InfinispanBatcher(this.cache);
        this.identifierFactory = new AffinityIdentifierFactory(configuration.getIdentifierFactory(), this.cache, configuration.getAffinityFactory());
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.expiration = configuration.getExpiration();
        this.primaryOwnerLocator = new PrimaryOwnerLocator(configuration.getCache(), configuration.getGroup());
        Group<Address> group = configuration.getGroup();
        this.strongAffinity = this.cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusterAffinity(group.getName()) : new NodeAffinity(group.getLocalMember().getName());
        this.filter = new InfinispanBeanMetaDataFilter(configuration.getBeanName());
    }

    public void start() {
        this.identifierFactory.start();
        Duration stopTimeout = Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout());
        PrimaryOwnerScheduler localScheduler = this.expiration != null && !this.expiration.getTimeout().isZero() ? new BeanExpirationScheduler(this.dispatcherFactory.getGroup(), this.batcher, this.beanFactory, this.expiration, stopTimeout) : null;
        String dispatcherName = String.join((CharSequence)"/", this.cache.getName(), this.filter.toString());
        this.scheduler = localScheduler != null ? (this.dispatcherFactory.getGroup().isSingleton() ? localScheduler : new PrimaryOwnerScheduler(this.dispatcherFactory, dispatcherName, (CacheEntryScheduler)localScheduler, this.primaryOwnerLocator, InfinispanBeanMetaDataKey::new, (BiFunction)(this.properties.isTransactional() ? new ScheduleWithExpirationMetaDataCommandFactory() : ScheduleWithTransientMetaDataCommand::new))) : null;
        ScheduleLocalEntriesTask scheduleTask = localScheduler != null ? new ScheduleLocalEntriesTask(this.cache, this.filter, (CacheEntryScheduler)localScheduler) : null;
        ListenerRegistration listenerRegistration = this.schedulerListenerRegistration = localScheduler != null ? new SchedulerTopologyChangeListener(this.cache, (CacheEntryScheduler)localScheduler, (BiConsumer)scheduleTask).register() : null;
        if (scheduleTask != null) {
            scheduleTask.accept(new SimpleLocality(false), new CacheLocality(this.cache));
        }
        Consumer<Bean> closeTask = this.expiration != null ? bean -> {
            if (bean.isValid()) {
                if (this.scheduler != null) {
                    this.scheduler.schedule(bean.getId(), (Object)bean.getMetaData());
                } else {
                    bean.remove(this.expiration.getExpirationListener());
                }
            }
        } : null;
        this.transformer = closeTask != null ? bean -> new OnCloseBean(bean, closeTask) : UnaryOperator.identity();
    }

    public void stop() {
        if (this.schedulerListenerRegistration != null) {
            this.schedulerListenerRegistration.close();
        }
        if (this.scheduler != null) {
            this.scheduler.close();
        }
        this.identifierFactory.stop();
    }

    public boolean isRemotable(Throwable throwable) {
        for (Throwable subject = throwable; subject != null; subject = subject.getCause()) {
            if (!(subject instanceof CacheException)) continue;
            return false;
        }
        return true;
    }

    public Affinity getStrongAffinity() {
        return this.strongAffinity;
    }

    public Affinity getWeakAffinity(K id) {
        Configuration config = this.cache.getCacheConfiguration();
        CacheMode mode = config.clustering().cacheMode();
        if (mode.isClustered()) {
            Node member = this.primaryOwnerLocator.apply((Key<K>)new GroupedKey(id));
            return new NodeAffinity(member.getName());
        }
        return Affinity.NONE;
    }

    public Bean<K, V> createBean(V instance, K groupId) {
        Object id = instance.getId();
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        MutableBean bean = this.beanFactory.createBean(id, this.beanFactory.createValue(instance, groupId));
        bean.setInstance(instance);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bean<K, V> findBean(K id) throws TimeoutException {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        Object value = this.beanFactory.findValue(id);
        if (value == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        if (this.scheduler != null) {
            this.scheduler.cancel(id);
        }
        try {
            MutableBean bean = this.beanFactory.createBean(id, value);
            if (bean.getInstance() == null) {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Bean %s metadata was found, but bean instance was not, most likely due to passivation failure.", id);
                try {
                    this.beanFactory.purge(id);
                }
                finally {
                    bean.close();
                }
                return null;
            }
            if (bean.getMetaData().isExpired()) {
                InfinispanEjbLogger.ROOT_LOGGER.debugf("Bean %s found, but was expired", id);
                try {
                    bean.remove(this.expiration.getExpirationListener());
                }
                finally {
                    bean.close();
                }
                return null;
            }
            return (Bean)this.transformer.apply((Bean<K, V>)bean);
        }
        catch (org.infinispan.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e.getLocalizedMessage());
        }
    }

    public Supplier<K> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public int getActiveCount() {
        return this.count(EnumSet.of(Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD));
    }

    public int getPassiveCount() {
        return this.count(EnumSet.of(Flag.CACHE_MODE_LOCAL)) - this.getActiveCount();
    }

    private int count(Set<Flag> flags) {
        try (CacheStream keys = this.cache.getAdvancedCache().withFlags(flags).keySet().stream();){
            int n = (int)keys.filter(InfinispanBeanGroupKey.class::isInstance).count();
            return n;
        }
    }
}

