/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.common.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String[] NO_STRINGS = new String[0];
    private static final Pattern ITEM_PATTERN = Pattern.compile("(,+)|([^\\\\,]+)|\\\\(.)");

    private StringUtil() {
    }

    public static String[] split(String text) {
        if (text == null || text.isEmpty()) {
            return NO_STRINGS;
        }
        Matcher matcher = ITEM_PATTERN.matcher(text);
        String item = null;
        StringBuilder b = null;
        ArrayList<String> list = new ArrayList<String>(4);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                if (item == null) continue;
                list.add(item);
                item = null;
                continue;
            }
            if (matcher.group(2) != null) {
                assert (item == null) : "Regular expression matching malfunctioned";
                item = matcher.group(2);
                continue;
            }
            if (matcher.group(3) != null) {
                if (b == null) {
                    b = new StringBuilder();
                }
                if (item != null) {
                    b.append(item);
                    item = null;
                }
                b.append(matcher.group(3));
                while (matcher.find() && matcher.group(1) == null) {
                    if (matcher.group(2) != null) {
                        b.append(matcher.group(2));
                        continue;
                    }
                    if (matcher.group(3) != null) {
                        b.append(matcher.group(3));
                        continue;
                    }
                    throw new IllegalStateException();
                }
                list.add(b.toString());
                b.setLength(0);
                continue;
            }
            throw new IllegalStateException();
        }
        if (item != null) {
            list.add(item);
        }
        return list.toArray(NO_STRINGS);
    }

    private static boolean isAsciiLetterOrDigit(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private static boolean isAsciiUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static char toAsciiLowerCase(char c) {
        return StringUtil.isAsciiUpperCase(c) ? (char)(c + 32) : c;
    }

    public static boolean equalsIgnoreCaseReplacingNonAlphanumericByUnderscores(String property, CharSequence mappedProperty) {
        int length = mappedProperty.length();
        if (property.length() != mappedProperty.length()) {
            if (length == 0 || property.length() != mappedProperty.length() + 1) {
                return false;
            }
            if (mappedProperty.charAt(length - 1) == '\"' && property.charAt(length - 1) == '_' && property.charAt(length) == '_') {
                length = mappedProperty.length() - 1;
            } else {
                return false;
            }
        }
        for (int i = 0; i < length; ++i) {
            char pCh;
            char ch = mappedProperty.charAt(i);
            if (!(!StringUtil.isAsciiLetterOrDigit(ch) ? property.charAt(i) != '_' : ((pCh = property.charAt(i)) < '\u0080' ? StringUtil.toAsciiLowerCase(pCh) != StringUtil.toAsciiLowerCase(ch) : Character.toLowerCase(property.charAt(i)) != Character.toLowerCase(ch)))) continue;
            return false;
        }
        return true;
    }

    public static String replaceNonAlphanumericByUnderscores(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (StringUtil.isAsciiLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append('_');
            if (c != '\"' || i + 1 != length) continue;
            sb.append('_');
        }
        return sb.toString();
    }

    public static String toLowerCaseAndDotted(String name) {
        int length = name.length();
        int beginSegment = 0;
        boolean quotesOpen = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('_' == c) {
                int j;
                if (i == 0) {
                    sb.append('%');
                    continue;
                }
                if (beginSegment > 0 && StringUtil.isNumeric(sb, beginSegment, i)) {
                    sb.setCharAt(beginSegment - 1, '[');
                    sb.append(']');
                    j = i + 1;
                    if (j >= length || '_' != name.charAt(j)) continue;
                    sb.append('.');
                    i = j;
                    continue;
                }
                j = i + 1;
                if (j < length) {
                    if ('_' == name.charAt(j) && !quotesOpen) {
                        sb.append('.');
                        sb.append('\"');
                        i = j;
                        quotesOpen = true;
                    } else if ('_' == name.charAt(j) && quotesOpen) {
                        sb.append('\"');
                        if (j + 1 < length) {
                            sb.append('.');
                        }
                        i = j;
                        quotesOpen = false;
                    } else {
                        sb.append('.');
                    }
                } else {
                    sb.append('.');
                }
                beginSegment = j;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static boolean isNumeric(CharSequence digits) {
        return StringUtil.isNumeric(digits, 0, digits.length());
    }

    public static boolean isNumeric(CharSequence digits, int start, int end) {
        if (digits.length() == 0) {
            return false;
        }
        for (int i = start; i < end; ++i) {
            if (Character.isDigit(digits.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String skewer(String camelHumps) {
        return StringUtil.skewer(camelHumps, '-');
    }

    public static String skewer(String camelHumps, char separator) {
        return StringUtil.skewer(camelHumps, 0, camelHumps.length(), new StringBuilder(), separator);
    }

    private static String skewer(String camelHumps, int start, int end, StringBuilder b, char separator) {
        if (camelHumps.isEmpty()) {
            throw new IllegalArgumentException("Method seems to have an empty name");
        }
        int cp = camelHumps.codePointAt(start);
        b.appendCodePoint(Character.toLowerCase(cp));
        if ((start += Character.charCount(cp)) == end) {
            return b.toString();
        }
        if (Character.isUpperCase(cp)) {
            int nextCp = camelHumps.codePointAt(start);
            if (Character.isUpperCase(nextCp)) {
                do {
                    b.appendCodePoint(Character.toLowerCase(nextCp));
                    cp = nextCp;
                    if ((start += Character.charCount(cp)) != end) continue;
                    return b.toString();
                } while (!Character.isLowerCase(nextCp = camelHumps.codePointAt(start)));
                b.append(separator);
                return StringUtil.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(nextCp);
            start += Character.charCount(nextCp);
            while (true) {
                if (start == end) {
                    return b.toString();
                }
                cp = camelHumps.codePointAt(start);
                if (Character.isUpperCase(cp)) {
                    b.append(separator);
                    return StringUtil.skewer(camelHumps, start, end, b, separator);
                }
                b.appendCodePoint(cp);
                start += Character.charCount(cp);
            }
        }
        do {
            if (Character.isUpperCase(cp = camelHumps.codePointAt(start))) {
                b.append(separator);
                return StringUtil.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(cp);
        } while ((start += Character.charCount(cp)) != end);
        return b.toString();
    }
}

