/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.renderkit.StateHelper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WebappLifecycleListener {
    private ServletContext servletContext;
    private ApplicationAssociate applicationAssociate;
    private Set<HttpSession> activeSessions = ConcurrentHashMap.newKeySet();

    public WebappLifecycleListener() {
    }

    public WebappLifecycleListener(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void requestInitialized(ServletRequestEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext instanceof InitFacesContext) {
            InitFacesContext initFacesContext = (InitFacesContext)facesContext;
            initFacesContext.releaseCurrentInstance();
            initFacesContext.removeServletContextEntryForInitContext();
        }
        ApplicationAssociate.setCurrentInstance(this.getAssociate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        try {
            HttpSession session;
            if (this.isDistributable(event) && (session = ((HttpServletRequest)event.getServletRequest()).getSession(false)) != null && session.getAttribute("com.sun.faces.application.view.activeViewMaps") != null) {
                session.setAttribute("com.sun.faces.application.view.activeViewMaps", session.getAttribute("com.sun.faces.application.view.activeViewMaps"));
            }
        }
        catch (Throwable t) {
            InitFacesContext context = new InitFacesContext(event.getServletContext());
            ((FacesContext)context).getApplication().publishEvent(context, ExceptionQueuedEvent.class, new ExceptionQueuedEventContext(context, t));
            context.getExceptionHandler().handle();
        }
        finally {
            ApplicationAssociate.setCurrentInstance(null);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        ApplicationAssociate associate = this.getAssociate();
        if (this.isDevModeEnabled(associate)) {
            this.activeSessions.add(event.getSession());
        }
        if (this.haveProtectedViews(associate)) {
            StateHelper.createAndStoreCryptographicallyStrongTokenInSession(event.getSession());
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.activeSessions.remove(event.getSession());
        FlowCDIContext.sessionDestroyed(event);
        for (HttpSessionListener listener : Arrays.asList((HttpSessionListener)this.servletContext.getAttribute("com.sun.faces.application.view.viewScopeManager"), (HttpSessionListener)this.servletContext.getAttribute("com.sun.faces.cdi.clientwindow.clientWindowScopeManager"))) {
            if (listener == null) continue;
            listener.sessionDestroyed(event);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        if (this.servletContext == null) {
            this.servletContext = event.getServletContext();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.applicationAssociate = null;
    }

    public List<HttpSession> getActiveSessions() {
        return new ArrayList<HttpSession>(this.activeSessions);
    }

    private ApplicationAssociate getAssociate() {
        if (this.applicationAssociate == null) {
            this.applicationAssociate = ApplicationAssociate.getInstance(this.servletContext);
        }
        return this.applicationAssociate;
    }

    private boolean isDistributable(ServletRequestEvent event) {
        return WebConfiguration.getInstance(event.getServletContext()).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableDistributable);
    }

    private boolean isDevModeEnabled(ApplicationAssociate associate) {
        return associate != null && associate.isDevModeEnabled();
    }

    private boolean haveProtectedViews(ApplicationAssociate associate) {
        return !associate.getApplication().getViewHandler().getProtectedViewsUnmodifiable().isEmpty();
    }
}

