/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConfigSource;
import io.smallrye.config.ConfigValueMapView;
import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class MapBackedConfigValueConfigSource
extends AbstractConfigSource
implements ConfigValueConfigSource {
    private static final long serialVersionUID = -4619155951589529987L;
    private final Map<String, ConfigValue> properties;

    public MapBackedConfigValueConfigSource(String name, Map<String, ConfigValue> propertyMap) {
        this(name, propertyMap, 100);
    }

    public MapBackedConfigValueConfigSource(String name, Map<String, ConfigValue> propertyMap, boolean copy) {
        this(name, propertyMap, 100, copy);
    }

    public MapBackedConfigValueConfigSource(String name, Map<String, ConfigValue> propertyMap, int defaultOrdinal) {
        super(name, ConfigSourceUtil.getOrdinalFromMap((Map)new ConfigValueMapView(propertyMap), (int)defaultOrdinal));
        this.properties = Collections.unmodifiableMap(propertyMap);
    }

    public MapBackedConfigValueConfigSource(String name, Map<String, ConfigValue> propertyMap, int defaultOrdinal, boolean copy) {
        this(name, (Map<String, ConfigValue>)(copy ? new LinkedHashMap(propertyMap) : propertyMap), defaultOrdinal);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public ConfigValue getConfigValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Map<String, ConfigValue> getConfigValueProperties() {
        return this.properties;
    }
}

