/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractIndexingConfigurationChildBuilder;
import org.infinispan.configuration.cache.IndexMergeConfigurationBuilder;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;

public class IndexWriterConfigurationBuilder
extends AbstractIndexingConfigurationChildBuilder
implements Builder<IndexWriterConfiguration> {
    private final AttributeSet attributes = IndexWriterConfiguration.attributeDefinitionSet();
    private final IndexMergeConfigurationBuilder indexMergeConfigurationBuilder;

    IndexWriterConfigurationBuilder(IndexingConfigurationBuilder builder) {
        super(builder);
        this.indexMergeConfigurationBuilder = new IndexMergeConfigurationBuilder(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexMergeConfigurationBuilder merge() {
        return this.indexMergeConfigurationBuilder;
    }

    public IndexWriterConfigurationBuilder threadPoolSize(int value) {
        this.attributes.attribute(IndexWriterConfiguration.INDEX_THREAD_POOL_SIZE).set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder queueCount(int value) {
        this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_COUNT).set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder queueSize(int value) {
        this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_SIZE).set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder commitInterval(int value) {
        this.attributes.attribute(IndexWriterConfiguration.INDEX_COMMIT_INTERVAL).set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder ramBufferSize(int value) {
        this.attributes.attribute(IndexWriterConfiguration.INDEX_RAM_BUFFER_SIZE).set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder maxBufferedEntries(int value) {
        this.attributes.attribute(IndexWriterConfiguration.INDEX_MAX_BUFFERED_ENTRIES).set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder setLowLevelTrace(boolean value) {
        this.attributes.attribute(IndexWriterConfiguration.INDEX_LOW_LEVEL_TRACE).set((Object)value);
        return this;
    }

    public IndexWriterConfiguration create() {
        return new IndexWriterConfiguration(this.attributes.protect(), this.indexMergeConfigurationBuilder.create());
    }

    public IndexWriterConfigurationBuilder read(IndexWriterConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.indexMergeConfigurationBuilder.read(template.merge(), combine);
        return this;
    }

    public String toString() {
        return "IndexWriterConfigurationBuilder{attributes=" + this.attributes + ", indexMergeConfigurationBuilder=" + this.indexMergeConfigurationBuilder + "}";
    }
}

