/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.Constants;
import org.infinispan.metrics.config.MicrometerMeterRegistryConfiguration;
import org.infinispan.metrics.impl.BaseAdditionalMetrics;
import org.infinispan.metrics.impl.NameUtils;
import org.infinispan.metrics.impl.TimerTrackerImpl;
import org.infinispan.metrics.impl.VendorAdditionalMetrics;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class MetricsCollector
implements Constants {
    private static final Log log = LogFactory.getLog(MetricsCollector.class);
    private MeterRegistry registry;
    private Tag nodeTag;
    private Tag cacheManagerTag;
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    ComponentRef<Transport> transportRef;

    protected MetricsCollector() {
    }

    public PrometheusMeterRegistry registry() {
        return this.registry instanceof PrometheusMeterRegistry ? (PrometheusMeterRegistry)this.registry : null;
    }

    @Start
    protected void start() {
        Transport transport;
        String nodeName;
        this.createMeterRegistry();
        new BaseAdditionalMetrics().bindTo(this.registry);
        new VendorAdditionalMetrics().bindTo(this.registry);
        if (this.globalConfig.metrics().namesAsTags()) {
            this.cacheManagerTag = Tag.of((String)"cache_manager", (String)this.globalConfig.cacheManagerName());
        }
        String string = nodeName = (transport = this.transportRef.running()) != null ? transport.getAddress().toString() : this.globalConfig.transport().nodeName();
        if (nodeName == null) {
            nodeName = MetricsCollector.generateRandomName();
        }
        this.nodeTag = Tag.of((String)"node", (String)nodeName);
    }

    @Stop
    protected void stop() {
        if (this.registry != null) {
            this.registry.close();
            this.registry = null;
        }
    }

    private static String generateRandomName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getByName(null).getHostName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (hostName == null) {
            hostName = "localhost";
        } else {
            int dotPos = hostName.indexOf(46);
            if (dotPos > 0 && !Character.isDigit(hostName.charAt(0))) {
                hostName = hostName.substring(0, dotPos);
            }
        }
        int rand = 1 + ThreadLocalRandom.current().nextInt(65534);
        return hostName + "-" + rand;
    }

    public Set<Object> registerMetrics(Object instance, Collection<MBeanMetadata.AttributeMetadata> attributes, String namePrefix, String cacheName) {
        return this.registerMetrics(instance, attributes, namePrefix, MetricsCollector.asTag("cache", cacheName), this.nodeTag);
    }

    public Set<Object> registerMetrics(Object instance, Collection<MBeanMetadata.AttributeMetadata> attributes, String namePrefix, String cacheName, String nodeName) {
        return this.registerMetrics(instance, attributes, namePrefix, MetricsCollector.asTag("cache", cacheName), MetricsCollector.asTag("node", nodeName));
    }

    public Set<Object> registerJGroupsMetrics(Object instance, Collection<MBeanMetadata.AttributeMetadata> attributes, String protocol, String clusterName, String nodeName) {
        String prefix = this.globalConfig.metrics().namesAsTags() ? "jgroups_" + protocol.toLowerCase() + "_" : "jgroups_" + clusterName + "_" + protocol.toLowerCase() + "_";
        return this.registerMetrics(instance, attributes, prefix, MetricsCollector.asTag("node", nodeName), MetricsCollector.asTag("cluster", clusterName));
    }

    private Set<Object> registerMetrics(Object instance, Collection<MBeanMetadata.AttributeMetadata> attributes, String namePrefix, Tag ... initialTags) {
        HashSet<Object> metricIds = new HashSet<Object>(attributes.size());
        GlobalMetricsConfiguration metricsCfg = this.globalConfig.metrics();
        for (MBeanMetadata.AttributeMetadata attr : attributes) {
            Meter.Id id;
            if (attr.isClusterWide()) continue;
            Supplier<?> getter = attr.getter(instance);
            Consumer<?> setter = attr.setter(instance);
            if (getter == null && setter == null) continue;
            String metricName = "vendor." + namePrefix + NameUtils.decamelize(attr.getName());
            if (getter != null) {
                if (!metricsCfg.gauges()) continue;
                Gauge gauge = Gauge.builder((String)metricName, getter).tags(this.prepareTags(attr, initialTags)).strongReference(true).description(attr.getDescription()).register(this.registry);
                id = gauge.getId();
                if (log.isTraceEnabled()) {
                    log.tracef("Registering gauge metric %s", id);
                }
                metricIds.add(id);
                continue;
            }
            if (!metricsCfg.histograms()) continue;
            Timer timer = Timer.builder((String)metricName).tags(this.prepareTags(attr, initialTags)).description(attr.getDescription()).register(this.registry);
            id = timer.getId();
            if (log.isTraceEnabled()) {
                log.tracef("Registering histogram metric %s", id);
            }
            setter.accept(new TimerTrackerImpl(timer));
            metricIds.add(id);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Registered %d metrics. Metric registry @%x contains %d metrics.", metricIds.size(), System.identityHashCode(this.registry), this.registry.getMeters().size());
        }
        return metricIds;
    }

    private static Tag mapEntryToTag(Map.Entry<String, String> entry) {
        return MetricsCollector.asTag(entry.getKey(), entry.getValue());
    }

    private List<Tag> prepareTags(MBeanMetadata.AttributeMetadata attr, Tag ... tags) {
        Stream<Tag> tagStream = attr.tags().entrySet().stream().map(MetricsCollector::mapEntryToTag);
        List<Tag> allTags = Stream.concat(Arrays.stream(tags), tagStream).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.cacheManagerTag != null) {
            allTags.add(this.cacheManagerTag);
        }
        return allTags;
    }

    private static Tag asTag(String key, String value) {
        return value != null ? Tag.of((String)key, (String)value) : null;
    }

    public void unregisterMetric(Object metricId) {
        if (this.registry == null) {
            return;
        }
        Meter removed = this.registry.remove((Meter.Id)metricId);
        if (log.isTraceEnabled()) {
            if (removed != null) {
                log.tracef("Unregistered metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.getMeters().size());
            } else {
                log.tracef("Could not remove unexisting metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.registry), this.registry.getMeters().size());
            }
        }
    }

    private void createMeterRegistry() {
        MicrometerMeterRegistryConfiguration configuration = this.globalConfig.module(MicrometerMeterRegistryConfiguration.class);
        MeterRegistry meterRegistry = this.registry = configuration == null ? null : configuration.meterRegistry();
        if (this.registry == null) {
            this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        }
    }
}

