/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.io.CountingOutputStream;
import org.eclipse.jgit.util.sha1.SHA1;

public class PackInserter
extends ObjectInserter {
    private static final int INDEX_VERSION = 2;
    private final ObjectDirectory db;
    private List<PackedObjectInfo> objectList;
    private ObjectIdOwnerMap<PackedObjectInfo> objectMap;
    private boolean rollback;
    private boolean checkExisting = true;
    private int compression = 9;
    private File tmpPack;
    private PackStream packOut;
    private Inflater cachedInflater;
    private PackConfig pconfig;

    PackInserter(ObjectDirectory db) {
        this.db = db;
        this.pconfig = new PackConfig(db.getConfig());
    }

    public void checkExisting(boolean check) {
        this.checkExisting = check;
    }

    public void setCompressionLevel(int compression) {
        this.compression = compression;
    }

    int getBufferSize() {
        return this.buffer().length;
    }

    @Override
    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        ObjectId id = this.idFor(type, data, off, len);
        if (this.objectMap != null && this.objectMap.contains(id)) {
            return id;
        }
        if (this.checkExisting && this.db.hasPackedObject(id)) {
            return id;
        }
        long offset = this.beginObject(type, len);
        this.packOut.compress.write(data, off, len);
        this.packOut.compress.finish();
        return this.endObject(id, offset);
    }

    @Override
    public ObjectId insert(int type, long len, InputStream in) throws IOException {
        byte[] buf = this.buffer();
        if (len <= (long)buf.length) {
            IO.readFully(in, buf, 0, (int)len);
            return this.insert(type, buf, 0, (int)len);
        }
        long offset = this.beginObject(type, len);
        SHA1 md = this.digest();
        md.update(Constants.encodedTypeString(type));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len));
        md.update((byte)0);
        while (0L < len) {
            int n = in.read(buf, 0, (int)Math.min((long)buf.length, len));
            if (n <= 0) {
                throw new EOFException();
            }
            md.update(buf, 0, n);
            this.packOut.compress.write(buf, 0, n);
            len -= (long)n;
        }
        this.packOut.compress.finish();
        return this.endObject(md.toObjectId(), offset);
    }

    private long beginObject(int type, long len) throws IOException {
        if (this.packOut == null) {
            this.beginPack();
        }
        long offset = this.packOut.getOffset();
        this.packOut.beginObject(type, len);
        return offset;
    }

    private ObjectId endObject(ObjectId id, long offset) {
        PackedObjectInfo obj = new PackedObjectInfo(id);
        obj.setOffset(offset);
        obj.setCRC((int)this.packOut.crc32.getValue());
        this.objectList.add(obj);
        this.objectMap.addIfAbsent(obj);
        return id;
    }

    private static File idxFor(File packFile) {
        String p = packFile.getName();
        return new File(packFile.getParentFile(), String.valueOf(p.substring(0, p.lastIndexOf(46))) + ".idx");
    }

    private void beginPack() throws IOException {
        this.objectList = new BlockList<PackedObjectInfo>();
        this.objectMap = new ObjectIdOwnerMap();
        this.rollback = true;
        this.tmpPack = File.createTempFile("insert_", ".pack", this.db.getDirectory());
        this.packOut = new PackStream(this.tmpPack);
        this.packOut.write(this.packOut.hdrBuf, 0, PackInserter.writePackHeader(this.packOut.hdrBuf, 1));
    }

    private static int writePackHeader(byte[] buf, int objectCount) {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, buf, 0, 4);
        NB.encodeInt32(buf, 4, 2);
        NB.encodeInt32(buf, 8, objectCount);
        return 12;
    }

    @Override
    public PackParser newPackParser(InputStream in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectReader newReader() {
        return new Reader();
    }

    @Override
    public void flush() throws IOException {
        byte[] packHash;
        if (this.tmpPack == null) {
            return;
        }
        if (this.packOut == null) {
            throw new IOException();
        }
        try {
            packHash = this.packOut.finishPack();
        }
        finally {
            this.packOut = null;
        }
        Collections.sort(this.objectList);
        File tmpIdx = PackInserter.idxFor(this.tmpPack);
        PackInserter.writePackIndex(tmpIdx, packHash, this.objectList);
        PackFile realPack = new PackFile(this.db.getPackDirectory(), this.computeName(this.objectList), PackExt.PACK);
        this.db.closeAllPackHandles(realPack);
        this.tmpPack.setReadOnly();
        FileUtils.rename(this.tmpPack, realPack, StandardCopyOption.ATOMIC_MOVE);
        PackFile realIdx = realPack.create(PackExt.INDEX);
        tmpIdx.setReadOnly();
        try {
            FileUtils.rename(tmpIdx, realIdx, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            File newIdx = new File(realIdx.getParentFile(), String.valueOf(realIdx.getName()) + ".new");
            try {
                FileUtils.rename(tmpIdx, newIdx, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e2) {
                newIdx = tmpIdx;
                e = e2;
            }
            throw new IOException(MessageFormat.format(JGitText.get().panicCantRenameIndexFile, newIdx, realIdx), e);
        }
        boolean interrupted = false;
        try {
            FileSnapshot snapshot = FileSnapshot.save(realPack);
            if (this.pconfig.doWaitPreventRacyPack(snapshot.size())) {
                snapshot.waitUntilNotRacy();
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        try {
            this.db.openPack(realPack);
            this.rollback = false;
        }
        finally {
            this.clear();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void writePackIndex(File idx, byte[] packHash, List<PackedObjectInfo> list) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream os = new FileOutputStream(idx);){
            PackIndexWriter w = PackIndexWriter.createVersion(os, 2);
            w.write(list, packHash);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ObjectId computeName(List<PackedObjectInfo> list) {
        SHA1 md = this.digest().reset();
        byte[] buf = this.buffer();
        for (PackedObjectInfo otp : list) {
            otp.copyRawTo(buf, 0);
            md.update(buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    @Override
    public void close() {
        block15: {
            try {
                if (this.packOut != null) {
                    try {
                        this.packOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!this.rollback || this.tmpPack == null) break block15;
                try {
                    FileUtils.delete(this.tmpPack);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    FileUtils.delete(PackInserter.idxFor(this.tmpPack));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.rollback = false;
            }
            finally {
                this.clear();
                try {
                    InflaterCache.release(this.cachedInflater);
                }
                finally {
                    this.cachedInflater = null;
                }
            }
        }
    }

    private void clear() {
        this.objectList = null;
        this.objectMap = null;
        this.tmpPack = null;
        this.packOut = null;
    }

    private Inflater inflater() {
        if (this.cachedInflater == null) {
            this.cachedInflater = InflaterCache.get();
        } else {
            this.cachedInflater.reset();
        }
        return this.cachedInflater;
    }

    private class PackStream
    extends OutputStream {
        final byte[] hdrBuf;
        final CRC32 crc32;
        final DeflaterOutputStream compress;
        private final RandomAccessFile file;
        private final CountingOutputStream out;
        private final Deflater deflater;
        private boolean atEnd;

        PackStream(File pack) throws IOException {
            this.file = new RandomAccessFile(pack, "rw");
            this.out = new CountingOutputStream(new FileOutputStream(this.file.getFD()));
            this.deflater = new Deflater(PackInserter.this.compression);
            this.compress = new DeflaterOutputStream((OutputStream)this, this.deflater, 8192);
            this.hdrBuf = new byte[32];
            this.crc32 = new CRC32();
            this.atEnd = true;
        }

        long getOffset() {
            return this.out.getCount();
        }

        void seek(long offset) throws IOException {
            this.file.seek(offset);
            this.atEnd = false;
        }

        void beginObject(int objectType, long length) throws IOException {
            this.crc32.reset();
            this.deflater.reset();
            this.write(this.hdrBuf, 0, this.encodeTypeSize(objectType, length));
        }

        private int encodeTypeSize(int type, long rawLength) {
            long nextLength = rawLength >>> 4;
            this.hdrBuf[0] = (byte)((long)((nextLength > 0L ? 128 : 0) | type << 4) | rawLength & 0xFL);
            rawLength = nextLength;
            int n = 1;
            while (rawLength > 0L) {
                this.hdrBuf[n++] = (byte)((long)((nextLength >>>= 7) > 0L ? 128 : 0) | rawLength & 0x7FL);
                rawLength = nextLength;
            }
            return n;
        }

        @Override
        public void write(int b) throws IOException {
            this.hdrBuf[0] = (byte)b;
            this.write(this.hdrBuf, 0, 1);
        }

        @Override
        public void write(byte[] data, int off, int len) throws IOException {
            this.crc32.update(data, off, len);
            if (!this.atEnd) {
                this.file.seek(this.file.length());
                this.atEnd = true;
            }
            this.out.write(data, off, len);
        }

        byte[] finishPack() throws IOException {
            try {
                int r;
                this.file.seek(0L);
                this.out.write(this.hdrBuf, 0, PackInserter.writePackHeader(this.hdrBuf, PackInserter.this.objectList.size()));
                byte[] buf = PackInserter.this.buffer();
                SHA1 md = PackInserter.this.digest().reset();
                this.file.seek(0L);
                while ((r = this.file.read(buf)) >= 0) {
                    md.update(buf, 0, r);
                }
                byte[] packHash = md.digest();
                this.out.write(packHash, 0, packHash.length);
                byte[] byArray = packHash;
                return byArray;
            }
            finally {
                this.close();
            }
        }

        @Override
        public void close() throws IOException {
            this.deflater.end();
            try {
                this.out.close();
            }
            finally {
                this.file.close();
            }
        }

        byte[] inflate(long filePos, int len) throws IOException, DataFormatException {
            byte[] dstbuf;
            try {
                dstbuf = new byte[len];
            }
            catch (OutOfMemoryError noMemory) {
                return null;
            }
            byte[] srcbuf = PackInserter.this.buffer();
            Inflater inf = PackInserter.this.inflater();
            filePos += (long)this.setInput(filePos, inf, srcbuf);
            int dstoff = 0;
            while (true) {
                int n = inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
                dstoff += n;
                if (inf.finished()) {
                    return dstbuf;
                }
                if (inf.needsInput()) {
                    filePos += (long)this.setInput(filePos, inf, srcbuf);
                    continue;
                }
                if (n == 0) break;
            }
            throw new DataFormatException();
        }

        private int setInput(long filePos, Inflater inf, byte[] buf) throws IOException {
            int n;
            if (this.file.getFilePointer() != filePos) {
                this.seek(filePos);
            }
            if ((n = this.file.read(buf)) < 0) {
                throw new EOFException(JGitText.get().unexpectedEofInPack);
            }
            inf.setInput(buf, 0, n);
            return n;
        }
    }

    private class Reader
    extends ObjectReader {
        private final ObjectReader ctx;

        private Reader() {
            this.ctx = PackInserter.this.db.newReader();
            this.setStreamFileThreshold(this.ctx.getStreamFileThreshold());
        }

        @Override
        public ObjectReader newReader() {
            return PackInserter.this.db.newReader();
        }

        @Override
        public ObjectInserter getCreatedFromInserter() {
            return PackInserter.this;
        }

        @Override
        public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
            Collection<ObjectId> stored = this.ctx.resolve(id);
            if (PackInserter.this.objectList == null) {
                return stored;
            }
            HashSet<ObjectId> r = new HashSet<ObjectId>(stored.size() + 2);
            r.addAll(stored);
            for (PackedObjectInfo obj : PackInserter.this.objectList) {
                if (id.prefixCompare(obj) != 0) continue;
                r.add(obj.copy());
            }
            return r;
        }

        @Override
        public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            byte[] data;
            if (PackInserter.this.objectMap == null) {
                return this.ctx.open(objectId, typeHint);
            }
            PackedObjectInfo obj = PackInserter.this.objectMap.get(objectId);
            if (obj == null) {
                return this.ctx.open(objectId, typeHint);
            }
            byte[] buf = PackInserter.this.buffer();
            PackInserter.this.packOut.seek(obj.getOffset());
            int cnt = PackInserter.this.packOut.file.read(buf, 0, 20);
            if (cnt <= 0) {
                throw new EOFException(JGitText.get().unexpectedEofInPack);
            }
            int c = buf[0] & 0xFF;
            int type = c >> 4 & 7;
            if (type == 6 || type == 7) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotReadBackDelta, Integer.toString(type)));
            }
            if (typeHint != -1 && type != typeHint) {
                throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
            }
            long sz = c & 0xF;
            int ptr = 1;
            int shift = 4;
            while ((c & 0x80) != 0) {
                if (ptr >= cnt) {
                    throw new EOFException(JGitText.get().unexpectedEofInPack);
                }
                c = buf[ptr++] & 0xFF;
                sz += (long)(c & 0x7F) << shift;
                shift += 7;
            }
            long zpos = obj.getOffset() + (long)ptr;
            if (sz < (long)this.getStreamFileThreshold() && (data = this.inflate(obj, zpos, (int)sz)) != null) {
                return new ObjectLoader.SmallObject(type, data);
            }
            return new StreamLoader(type, sz, zpos);
        }

        private byte[] inflate(PackedObjectInfo obj, long zpos, int sz) throws IOException, CorruptObjectException {
            try {
                return PackInserter.this.packOut.inflate(zpos, sz);
            }
            catch (DataFormatException dfe) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, obj.getOffset(), PackInserter.this.tmpPack.getAbsolutePath()), dfe);
            }
        }

        @Override
        public Set<ObjectId> getShallowCommits() throws IOException {
            return this.ctx.getShallowCommits();
        }

        @Override
        public void close() {
            this.ctx.close();
        }

        private class StreamLoader
        extends ObjectLoader {
            private final int type;
            private final long size;
            private final long pos;

            StreamLoader(int type, long size, long pos) {
                this.type = type;
                this.size = size;
                this.pos = pos;
            }

            @Override
            public ObjectStream openStream() throws MissingObjectException, IOException {
                int bufsz = PackInserter.this.buffer().length;
                ((Reader)Reader.this).PackInserter.this.packOut.seek(this.pos);
                FilterInputStream fileStream = new FilterInputStream(Channels.newInputStream(((Reader)Reader.this).PackInserter.this.packOut.file.getChannel())){

                    @Override
                    public int read() throws IOException {
                        ((Reader)((StreamLoader)StreamLoader.this).Reader.this).PackInserter.this.packOut.atEnd = false;
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        ((Reader)((StreamLoader)StreamLoader.this).Reader.this).PackInserter.this.packOut.atEnd = false;
                        return super.read(b);
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        ((Reader)((StreamLoader)StreamLoader.this).Reader.this).PackInserter.this.packOut.atEnd = false;
                        return super.read(b, off, len);
                    }

                    @Override
                    public void close() {
                    }
                };
                return new ObjectStream.Filter(this.type, this.size, new BufferedInputStream(new InflaterInputStream(fileStream, PackInserter.this.inflater(), bufsz), bufsz));
            }

            @Override
            public int getType() {
                return this.type;
            }

            @Override
            public long getSize() {
                return this.size;
            }

            @Override
            public byte[] getCachedBytes() throws LargeObjectException {
                throw new LargeObjectException.ExceedsLimit(Reader.this.getStreamFileThreshold(), this.size);
            }
        }
    }
}

