/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.security;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.host.controller.security.ServerVerificationService;
import org.jboss.as.server.security.sasl.DomainServerSaslServerFactory;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.sasl.util.AggregateSaslServerFactory;

public class SaslWrappingService
implements Service {
    private final Supplier<SaslAuthenticationFactory> originalFactorySupplier;
    private final Consumer<SaslAuthenticationFactory> wrappedFactoryConsumer;
    private final Supplier<Predicate<Evidence>> evidenceVerifierSupplier;

    SaslWrappingService(Supplier<SaslAuthenticationFactory> originalFactorySupplier, Consumer<SaslAuthenticationFactory> wrappedFactoryConsumer, Supplier<Predicate<Evidence>> evidenceVerifierSupplier) {
        this.originalFactorySupplier = originalFactorySupplier;
        this.wrappedFactoryConsumer = wrappedFactoryConsumer;
        this.evidenceVerifierSupplier = evidenceVerifierSupplier;
    }

    public void start(StartContext context) throws StartException {
        SaslAuthenticationFactory originalFactory = this.originalFactorySupplier.get();
        SaslServerFactory originalServerFactory = (SaslServerFactory)originalFactory.getFactory();
        DomainServerSaslServerFactory domainServerSaslFactory = new DomainServerSaslServerFactory(originalFactory.getSecurityDomain(), this.evidenceVerifierSupplier.get());
        MechanismConfigurationSelector originalMechanismConfigurationSelector = originalFactory.getMechanismConfigurationSelector();
        MechanismConfigurationSelector forJBossDomainServer = MechanismConfigurationSelector.predicateSelector(mi -> "JBOSS-DOMAIN-SERVER".equals(mi.getMechanismName()), (MechanismConfiguration)MechanismConfiguration.EMPTY);
        SaslAuthenticationFactory combinedFactory = SaslAuthenticationFactory.builder().setFactory((SaslServerFactory)new AggregateSaslServerFactory(new SaslServerFactory[]{originalServerFactory, domainServerSaslFactory})).setMechanismConfigurationSelector(MechanismConfigurationSelector.aggregate((MechanismConfigurationSelector[])new MechanismConfigurationSelector[]{originalMechanismConfigurationSelector, forJBossDomainServer})).setSecurityDomain(originalFactory.getSecurityDomain()).build();
        this.wrappedFactoryConsumer.accept(combinedFactory);
    }

    public void stop(StopContext context) {
    }

    public static ServiceName install(ServiceTarget serviceTarget, ServiceName originalSaslServerFactory, String forInterface) {
        if (originalSaslServerFactory == null) {
            return null;
        }
        ServiceName wrapperName = originalSaslServerFactory.append(new String[]{"wrapper", forInterface});
        ServiceBuilder sb = serviceTarget.addService(wrapperName);
        Supplier originalFactorySupplier = sb.requires(originalSaslServerFactory);
        Consumer wrappedFactoryConsumer = sb.provides(new ServiceName[]{wrapperName});
        Supplier evidenceVerifierSupplier = sb.requires(ServerVerificationService.SERVICE_NAME);
        sb.setInstance((Service)new SaslWrappingService(originalFactorySupplier, wrappedFactoryConsumer, evidenceVerifierSupplier)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return wrapperName;
    }
}

