/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class Decimal128Type
extends AbstractPrimitiveType<Decimal128> {
    private Decimal128Encoding _decimal128Encoder;

    Decimal128Type(EncoderImpl encoder, DecoderImpl decoder) {
        this._decimal128Encoder = new Decimal128Encoding(encoder, decoder);
        encoder.register(Decimal128.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Decimal128> getTypeClass() {
        return Decimal128.class;
    }

    public Decimal128Encoding getEncoding(Decimal128 val) {
        return this._decimal128Encoder;
    }

    @Override
    public Decimal128Encoding getCanonicalEncoding() {
        return this._decimal128Encoder;
    }

    @Override
    public Collection<Decimal128Encoding> getAllEncodings() {
        return Collections.singleton(this._decimal128Encoder);
    }

    private class Decimal128Encoding
    extends FixedSizePrimitiveTypeEncoding<Decimal128> {
        public Decimal128Encoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 16;
        }

        @Override
        public byte getEncodingCode() {
            return -108;
        }

        @Override
        public Decimal128Type getType() {
            return Decimal128Type.this;
        }

        @Override
        public void writeValue(Decimal128 val) {
            this.getEncoder().writeRaw(val.getMostSignificantBits());
            this.getEncoder().writeRaw(val.getLeastSignificantBits());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Decimal128> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Decimal128 readValue() {
            long msb = this.getDecoder().readRawLong();
            long lsb = this.getDecoder().readRawLong();
            return new Decimal128(msb, lsb);
        }
    }
}

