/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

class PropertyNamesConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 5263983885197566053L;
    private final Set<String> properties = new HashSet<String>();

    public PropertyNamesConfigSourceInterceptor(ConfigSourceInterceptorContext context, List<ConfigSource> sources) {
        this.properties.addAll(PropertyNamesConfigSourceInterceptor.generateDottedProperties(context, sources));
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        return context.proceed(name);
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator<String> namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            names.add(namesIterator.next());
        }
        names.addAll(this.properties);
        return names.iterator();
    }

    void addProperties(Set<String> properties) {
        this.properties.addAll(properties);
    }

    private static Set<String> generateDottedProperties(ConfigSourceInterceptorContext current, List<ConfigSource> sources) {
        HashSet<String> properties = new HashSet<String>();
        Iterator<String> iterateNames = current.iterateNames();
        while (iterateNames.hasNext()) {
            properties.add(iterateNames.next());
        }
        HashSet envProperties = new HashSet();
        for (ConfigSource configSource : sources) {
            if (!(configSource instanceof EnvConfigSource)) continue;
            envProperties.addAll(configSource.getPropertyNames());
        }
        properties.removeAll(envProperties);
        HashSet<String> overrides = new HashSet<String>();
        block2: for (String property : properties) {
            String semanticProperty = StringUtil.replaceNonAlphanumericByUnderscores((String)property);
            for (String envProperty : envProperties) {
                if (!envProperty.equalsIgnoreCase(semanticProperty)) continue;
                overrides.add(envProperty);
                continue block2;
            }
        }
        envProperties.removeAll(overrides);
        HashSet<String> hashSet = new HashSet<String>();
        for (String envProperty : envProperties) {
            hashSet.add(StringUtil.toLowerCaseAndDotted((String)envProperty));
        }
        return hashSet;
    }
}

