/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal.proxy.nonjaxrs;

import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipant;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipantRegistry;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.Status;

@ApplicationScoped
@Path(value="lra-participant-proxy")
public class LRAParticipantResource {
    static final String RESOURCE_PATH = "lra-participant-proxy";
    @Inject
    private LRAParticipantRegistry lraParticipantRegistry;

    @PUT
    @Path(value="{participantId}/compensate")
    @Produces(value={"text/plain"})
    @Compensate
    public Response compensate(@PathParam(value="participantId") String participantId, @HeaderParam(value="Long-Running-Action") String lraId, @HeaderParam(value="Long-Running-Action-Parent") String parentId) {
        return this.getParticipant(participantId).compensate(this.createURI(lraId), this.createURI(parentId));
    }

    @PUT
    @Path(value="{participantId}/complete")
    @Produces(value={"text/plain"})
    @Complete
    public Response complete(@PathParam(value="participantId") String participantId, @HeaderParam(value="Long-Running-Action") String lraId, @HeaderParam(value="Long-Running-Action-Parent") String parentId) {
        return this.getParticipant(participantId).complete(this.createURI(lraId), this.createURI(parentId));
    }

    @GET
    @Path(value="{participantId}/status")
    @Produces(value={"text/plain"})
    @Status
    public Response status(@PathParam(value="participantId") String participantId, @HeaderParam(value="Long-Running-Action") String lraId, @HeaderParam(value="Long-Running-Action-Parent") String parentId) {
        return this.getParticipant(participantId).status(this.createURI(lraId), this.createURI(parentId));
    }

    @DELETE
    @Path(value="{participantId}/forget")
    @Produces(value={"text/plain"})
    @Forget
    public Response forget(@PathParam(value="participantId") String participantId, @HeaderParam(value="Long-Running-Action") String lraId, @HeaderParam(value="Long-Running-Action-Parent") String parentId) {
        return this.getParticipant(participantId).forget(this.createURI(lraId), this.createURI(parentId));
    }

    @PUT
    @Path(value="{participantId}/after")
    @AfterLRA
    public Response afterLRA(@PathParam(value="participantId") String participantId, @HeaderParam(value="Long-Running-Action-Ended") URI lraId, LRAStatus lraStatus) {
        return this.getParticipant(participantId).afterLRA(lraId, lraStatus);
    }

    private LRAParticipant getParticipant(String participantId) {
        LRAParticipant participant = this.lraParticipantRegistry.getParticipant(participantId);
        if (participant == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(participantId + ": Cannot find participant in LRA registry")).build());
        }
        return participant;
    }

    private URI createURI(String value) {
        return value != null ? URI.create(value) : null;
    }
}

