/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.List;
import org.hibernate.QueryTimeoutException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.Query;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.mapper.orm.loading.impl.EntityGraphHint;
import org.hibernate.search.mapper.orm.loading.impl.LoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;

abstract class AbstractHibernateOrmSelectionEntityLoader<E>
implements PojoSelectionEntityLoader<E> {
    protected static final String IDS_PARAMETER_NAME = "ids";
    protected final EntityMappingType entityMappingType;
    protected final LoadingSessionContext sessionContext;
    protected final MutableEntityLoadingOptions loadingOptions;
    protected final TypeQueryFactory<E, ?> queryFactory;

    public AbstractHibernateOrmSelectionEntityLoader(EntityMappingType entityMappingType, TypeQueryFactory<E, ?> queryFactory, LoadingSessionContext sessionContext, MutableEntityLoadingOptions loadingOptions) {
        this.entityMappingType = entityMappingType;
        this.sessionContext = sessionContext;
        this.loadingOptions = loadingOptions;
        this.queryFactory = queryFactory;
    }

    public final List<E> loadBlocking(List<?> identifiers, Deadline deadline) {
        Long timeout = deadline == null ? null : Long.valueOf(deadline.checkRemainingTimeMillis());
        try {
            return this.doLoadEntities(identifiers, timeout);
        }
        catch (jakarta.persistence.LockTimeoutException | jakarta.persistence.QueryTimeoutException | QueryTimeoutException | LockTimeoutException e) {
            if (deadline == null) {
                throw e;
            }
            throw deadline.forceTimeoutAndCreateException((Exception)e);
        }
    }

    abstract List<E> doLoadEntities(List<?> var1, Long var2);

    final Query<E> createQuery(int fetchSize, Long timeout) {
        EntityGraphHint<?> entityGraphHint;
        Query<E> query = this.queryFactory.createQueryForLoadByUniqueProperty(this.sessionContext.session(), IDS_PARAMETER_NAME);
        query.setFetchSize(fetchSize);
        if (timeout != null) {
            query.setHint("javax.persistence.query.timeout", (Object)Math.toIntExact(timeout));
        }
        if ((entityGraphHint = this.loadingOptions.entityGraphHintOrNullForType(this.entityMappingType)) != null) {
            query.applyGraph(entityGraphHint.graph, entityGraphHint.semantic);
        }
        return query;
    }
}

