/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.transaction.Synchronization;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Transaction;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.mapper.orm.automaticindexing.AutomaticIndexingStrategyName;
import org.hibernate.search.mapper.orm.automaticindexing.impl.AutomaticIndexingStrategyStartContext;
import org.hibernate.search.mapper.orm.automaticindexing.impl.HibernateOrmIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.orm.automaticindexing.session.AutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingEventSendingSessionContext;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.orm.cfg.HibernateOrmMapperSettings;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateSearchEventListener;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.session.impl.AfterCommitIndexingPlanSynchronization;
import org.hibernate.search.mapper.orm.session.impl.BeforeCommitIndexingPlanSynchronization;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmIndexingPlanSynchronizationStrategyAdapter;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSession;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionHolder;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionMappingContext;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.IndexingPlanSynchronizationStrategyConfigurationContext;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredIndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventProcessingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ConfiguredAutomaticIndexingStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<Boolean> AUTOMATIC_INDEXING_ENABLED = ConfigurationProperty.forKey((String)"automatic_indexing.enabled").asBoolean().build();
    private static final OptionalConfigurationProperty<Boolean> INDEXING_LISTENERS_ENABLED = ConfigurationProperty.forKey((String)"indexing.listeners.enabled").asBoolean().build();
    private static final OptionalConfigurationProperty<Boolean> AUTOMATIC_INDEXING_ENABLED_LEGACY_STRATEGY = ConfigurationProperty.forKey((String)"automatic_indexing.strategy").as(Boolean.class, v -> !AutomaticIndexingStrategyName.NONE.equals((Object)AutomaticIndexingStrategyName.of(v))).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends AutomaticIndexingSynchronizationStrategy>> AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"automatic_indexing.synchronization.strategy").asBeanReference(AutomaticIndexingSynchronizationStrategy.class).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends IndexingPlanSynchronizationStrategy>> INDEXING_PLAN_SYNCHRONIZATION_STRATEGY = ConfigurationProperty.forKey((String)"indexing.plan.synchronization.strategy").asBeanReference(IndexingPlanSynchronizationStrategy.class).build();
    private static final ConfigurationProperty<Boolean> AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK = ConfigurationProperty.forKey((String)"automatic_indexing.enable_dirty_check").asBoolean().withDefault((Object)true).build();
    private final Function<AutomaticIndexingEventSendingSessionContext, AutomaticIndexingQueueEventSendingPlan> senderFactory;
    private final boolean enlistsInTransaction;
    private HibernateOrmSearchSessionMappingContext mappingContext;
    private BeanHolder<? extends IndexingPlanSynchronizationStrategy> defaultSynchronizationStrategyHolder;
    private ConfiguredIndexingPlanSynchronizationStrategy defaultSynchronizationStrategy;

    public ConfiguredAutomaticIndexingStrategy(Function<AutomaticIndexingEventSendingSessionContext, AutomaticIndexingQueueEventSendingPlan> senderFactory, boolean enlistsInTransaction) {
        this.senderFactory = senderFactory;
        this.enlistsInTransaction = enlistsInTransaction;
    }

    public boolean usesAsyncProcessing() {
        return this.senderFactory != null;
    }

    public void start(HibernateOrmSearchSessionMappingContext mappingContext, AutomaticIndexingStrategyStartContext startContext, HibernateOrmListenerContextProvider contextProvider) {
        this.mappingContext = mappingContext;
        ConfigurationPropertySource configurationSource = startContext.configurationPropertySource();
        this.resolveDefaultSyncStrategyHolder(startContext);
        this.defaultSynchronizationStrategy = this.configure((IndexingPlanSynchronizationStrategy)this.defaultSynchronizationStrategyHolder.get());
        Optional automaticIndexingEnabledOptional = (Optional)AUTOMATIC_INDEXING_ENABLED.get(configurationSource);
        Optional indexingListenersEnabledOptional = (Optional)INDEXING_LISTENERS_ENABLED.get(configurationSource);
        if (automaticIndexingEnabledOptional.isPresent()) {
            if (indexingListenersEnabledOptional.isPresent()) {
                throw log.bothNewAndOldConfigurationPropertiesForIndexingListenersAreUsed(AUTOMATIC_INDEXING_ENABLED.resolveOrRaw(configurationSource), INDEXING_LISTENERS_ENABLED.resolveOrRaw(configurationSource));
            }
            log.deprecatedPropertyUsedInsteadOfNew(AUTOMATIC_INDEXING_ENABLED.resolveOrRaw(configurationSource), INDEXING_LISTENERS_ENABLED.resolveOrRaw(configurationSource));
        }
        if (automaticIndexingEnabledOptional.orElse(indexingListenersEnabledOptional.orElse(true)).booleanValue() && AUTOMATIC_INDEXING_ENABLED_LEGACY_STRATEGY.getAndMap(configurationSource, enabled -> {
            log.deprecatedPropertyUsedInsteadOfNew(AUTOMATIC_INDEXING_ENABLED_LEGACY_STRATEGY.resolveOrRaw(configurationSource), INDEXING_LISTENERS_ENABLED.resolveOrRaw(configurationSource));
            return enabled;
        }).orElse(true).booleanValue()) {
            log.debug("Hibernate Search event listeners activated");
            HibernateSearchEventListener hibernateSearchEventListener = new HibernateSearchEventListener(contextProvider, (Boolean)AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK.getAndTransform(startContext.configurationPropertySource(), dirtyCheckingEnabled -> {
                if (!dirtyCheckingEnabled.booleanValue()) {
                    log.automaticIndexingEnableDirtyCheckIsDeprecated(AUTOMATIC_INDEXING_ENABLE_DIRTY_CHECK.resolveOrRaw(startContext.configurationPropertySource()));
                }
                return dirtyCheckingEnabled;
            }));
            hibernateSearchEventListener.registerTo(mappingContext.sessionFactory());
        } else {
            log.debug("Hibernate Search event listeners deactivated");
        }
    }

    private void resolveDefaultSyncStrategyHolder(AutomaticIndexingStrategyStartContext startContext) {
        ConfigurationPropertySource configurationSource = startContext.configurationPropertySource();
        boolean legacyStrategySet = ((Optional)AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.get(configurationSource)).isPresent();
        boolean newStrategySet = ((Optional)INDEXING_PLAN_SYNCHRONIZATION_STRATEGY.get(configurationSource)).isPresent();
        if (legacyStrategySet && newStrategySet) {
            throw log.bothNewAndOldConfigurationPropertiesForIndexingPlanSyncAreUsed(INDEXING_PLAN_SYNCHRONIZATION_STRATEGY.resolveOrRaw(configurationSource), AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.resolveOrRaw(configurationSource));
        }
        if (this.usesAsyncProcessing()) {
            if (legacyStrategySet || newStrategySet) {
                throw log.cannotConfigureSynchronizationStrategyWithIndexingEventQueue();
            }
            this.defaultSynchronizationStrategyHolder = BeanHolder.of((Object)IndexingPlanSynchronizationStrategy.writeSync());
        } else if (legacyStrategySet) {
            BeanHolder holder = (BeanHolder)AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.getAndMap(configurationSource, reference -> {
                log.automaticIndexingSynchronizationStrategyIsDeprecated(AUTOMATIC_INDEXING_SYNCHRONIZATION_STRATEGY.resolveOrRaw(configurationSource), INDEXING_PLAN_SYNCHRONIZATION_STRATEGY.resolveOrRaw(configurationSource));
                return startContext.beanResolver().resolve(reference);
            }).get();
            this.defaultSynchronizationStrategyHolder = BeanHolder.of((Object)new HibernateOrmIndexingPlanSynchronizationStrategyAdapter((AutomaticIndexingSynchronizationStrategy)holder.get())).withDependencyAutoClosing(new BeanHolder[]{holder});
        } else {
            this.defaultSynchronizationStrategyHolder = (BeanHolder)INDEXING_PLAN_SYNCHRONIZATION_STRATEGY.getAndTransform(configurationSource, referenceOptional -> startContext.beanResolver().resolve(referenceOptional.orElse(HibernateOrmMapperSettings.Defaults.INDEXING_PLAN_SYNCHRONIZATION_STRATEGY)));
        }
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.defaultSynchronizationStrategyHolder);
            this.defaultSynchronizationStrategy = null;
            this.defaultSynchronizationStrategyHolder = null;
            this.mappingContext = null;
        }
    }

    public ConfiguredIndexingPlanSynchronizationStrategy defaultIndexingPlanSynchronizationStrategy() {
        return this.defaultSynchronizationStrategy;
    }

    public ConfiguredIndexingPlanSynchronizationStrategy configureOverriddenSynchronizationStrategy(IndexingPlanSynchronizationStrategy synchronizationStrategy) {
        if (this.usesAsyncProcessing()) {
            throw log.cannotConfigureSynchronizationStrategyWithIndexingEventQueue();
        }
        return this.configure(synchronizationStrategy);
    }

    public PojoIndexingPlan createIndexingPlan(HibernateOrmSearchSession context, ConfiguredIndexingPlanSynchronizationStrategy synchronizationStrategy) {
        if (this.usesAsyncProcessing()) {
            AutomaticIndexingQueueEventSendingPlan delegate = this.senderFactory.apply(context);
            return this.mappingContext.createIndexingPlan((PojoWorkSessionContext)context, new HibernateOrmIndexingQueueEventSendingPlan(delegate));
        }
        return this.mappingContext.createIndexingPlan((PojoWorkSessionContext)context, synchronizationStrategy.documentCommitStrategy(), synchronizationStrategy.documentRefreshStrategy());
    }

    public Synchronization createTransactionWorkQueueSynchronization(PojoIndexingPlan indexingPlan, HibernateOrmSearchSessionHolder sessionProperties, Transaction transactionIdentifier, ConfiguredIndexingPlanSynchronizationStrategy synchronizationStrategy) {
        if (this.enlistsInTransaction) {
            return new BeforeCommitIndexingPlanSynchronization(indexingPlan, sessionProperties, transactionIdentifier, synchronizationStrategy);
        }
        return new AfterCommitIndexingPlanSynchronization(indexingPlan, sessionProperties, transactionIdentifier, synchronizationStrategy);
    }

    public PojoIndexingQueueEventProcessingPlan createIndexingQueueEventProcessingPlan(HibernateOrmSearchSession context, ConfiguredIndexingPlanSynchronizationStrategy synchronizationStrategy) {
        AutomaticIndexingQueueEventSendingPlan delegate = this.senderFactory.apply(context);
        return this.mappingContext.createIndexingQueueEventProcessingPlan((PojoWorkSessionContext)context, synchronizationStrategy.documentCommitStrategy(), synchronizationStrategy.documentRefreshStrategy(), new HibernateOrmIndexingQueueEventSendingPlan(delegate));
    }

    private ConfiguredIndexingPlanSynchronizationStrategy configure(IndexingPlanSynchronizationStrategy synchronizationStrategy) {
        ConfiguredIndexingPlanSynchronizationStrategy.Builder builder = new ConfiguredIndexingPlanSynchronizationStrategy.Builder(this.mappingContext.failureHandler());
        synchronizationStrategy.apply((IndexingPlanSynchronizationStrategyConfigurationContext)builder);
        return builder.build();
    }
}

