/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.tenancy.spi;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class TenancyConfiguration {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<List<String>> MULTI_TENANCY_TENANT_IDS = ConfigurationProperty.forKey((String)"multi_tenancy.tenant_ids").asString().multivalued().validate(value -> Contracts.assertNotNullNorEmpty((Collection)value, (String)"value")).build();
    private final Optional<Set<String>> tenantIds;
    private final String tenantIdsConfigurationPropertyKey;

    public static TenancyConfiguration create(TenancyMode tenancyMode, ConfigurationPropertySource configurationPropertySource) {
        String tenantIdsConfigurationPropertyKey = MULTI_TENANCY_TENANT_IDS.resolveOrRaw(configurationPropertySource);
        switch (tenancyMode) {
            case SINGLE_TENANCY: {
                return new TenancyConfiguration(Optional.of(Collections.emptySet()), tenantIdsConfigurationPropertyKey);
            }
            case MULTI_TENANCY: {
                return new TenancyConfiguration(MULTI_TENANCY_TENANT_IDS.getAndMap(configurationPropertySource, LinkedHashSet::new), tenantIdsConfigurationPropertyKey);
            }
        }
        throw new AssertionFailure("Unknown tenancy mode: " + tenancyMode);
    }

    private TenancyConfiguration(Optional<Set<String>> tenantIds, String tenantIdsConfigurationPropertyKey) {
        this.tenantIds = tenantIds;
        this.tenantIdsConfigurationPropertyKey = tenantIdsConfigurationPropertyKey;
    }

    public Set<String> tenantIdsOrFail() {
        return this.tenantIds.orElseThrow(() -> log.missingTenantIdConfiguration(this.tenantIdsConfigurationPropertyKey));
    }

    public SearchException invalidTenantId(String tenantId) {
        return log.invalidTenantId(tenantId, this.tenantIds.orElse(Collections.emptySet()), this.tenantIdsConfigurationPropertyKey);
    }
}

