/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.cxf.Bus;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.StackConfig;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;
import org.jboss.wsf.stack.cxf.i18n.Loggers;

class CXFStackConfig
implements StackConfig {
    public CXFStackConfig() {
        ClassLoader orig = CXFStackConfig.getContextClassLoader();
        try {
            CXFStackConfig.setContextClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            WSProviderConfig.init((boolean)true, (boolean)false, (boolean)true);
        }
        catch (Exception e) {
            Loggers.ROOT_LOGGER.couldNotInitSecurityEngine();
            Loggers.ROOT_LOGGER.errorGettingWSSConfig((Throwable)e);
        }
        finally {
            CXFStackConfig.setContextClassLoader(orig);
        }
    }

    public String getImplementationTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append("JBossWS ");
        sb.append(this.getClass().getPackage().getImplementationVersion());
        sb.append(" (Apache CXF ");
        sb.append(Bus.class.getPackage().getImplementationVersion());
        sb.append(")");
        return sb.toString();
    }

    public String getImplementationVersion() {
        return "";
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    public void validatePathRewriteRule(String rule) {
        SoapAddressRewriteHelper.validatePathRewriteRule(rule);
    }
}

