/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducerCreditsImpl
implements ClientProducerCredits {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int pendingCredits;
    protected final int windowSize;
    protected volatile boolean closed;
    protected boolean blocked;
    protected final SimpleString address;
    private final ClientSessionInternal session;
    protected int arriving;
    private int refCount;
    protected boolean serverRespondedWithFail;
    protected SessionContext sessionContext;

    public AbstractProducerCreditsImpl(ClientSessionInternal session, SimpleString address, int windowSize) {
        this.session = session;
        this.address = address;
        this.windowSize = windowSize / 2;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void init(SessionContext sessionContext) {
        this.checkCredits(this.windowSize);
        this.sessionContext = sessionContext;
        this.sessionContext.linkFlowControl(this.address, this);
    }

    @Override
    public void acquireCredits(int credits) throws ActiveMQException {
        this.checkCredits(credits);
        this.actualAcquire(credits);
        this.afterAcquired(credits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterAcquired(int credits) throws ActiveMQAddressFullException {
        if (logger.isDebugEnabled()) {
            logger.debug("AfterAcquire {} credits on address {}", (Object)credits, (Object)this.address);
        }
        AbstractProducerCreditsImpl abstractProducerCreditsImpl = this;
        synchronized (abstractProducerCreditsImpl) {
            this.pendingCredits -= credits;
        }
    }

    protected abstract void actualAcquire(int var1);

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public void receiveFailCredits(int credits) {
        this.serverRespondedWithFail = true;
        this.receiveCredits(credits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveCredits(int credits) {
        AbstractProducerCreditsImpl abstractProducerCreditsImpl = this;
        synchronized (abstractProducerCreditsImpl) {
            this.arriving -= credits;
        }
    }

    @Override
    public synchronized void reset() {
        logger.debug("reset credits on address {}", (Object)this.address);
        int beforeFailure = this.pendingCredits;
        this.pendingCredits = 0;
        this.arriving = 0;
        this.checkCredits(Math.max(this.windowSize * 2, beforeFailure));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public synchronized void incrementRefCount() {
        ++this.refCount;
    }

    @Override
    public synchronized int decrementRefCount() {
        return --this.refCount;
    }

    public abstract int getBalance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCredits(int credits) {
        int needed = Math.max(credits, this.windowSize);
        if (logger.isTraceEnabled()) {
            logger.trace("CheckCredits {} on address {}, needed={}, credits={}, window={}", credits, this.address, needed, credits, this.windowSize);
        }
        int toRequest = -1;
        AbstractProducerCreditsImpl abstractProducerCreditsImpl = this;
        synchronized (abstractProducerCreditsImpl) {
            if (this.getBalance() + this.arriving < needed) {
                toRequest = needed - this.arriving;
                if (logger.isTraceEnabled()) {
                    logger.trace("CheckCredits on Address {}, requesting={}, arriving={}, balance={}", this.address, toRequest, this.arriving, this.getBalance());
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace("CheckCredits did not need it, balance={}, arriving={},  needed={}, getbalance + arriving < needed={}", this.getBalance(), this.arriving, needed, this.getBalance() + this.arriving < needed);
            }
        }
        if (toRequest > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Requesting {} credits on address {}, needed = {}, arriving = {}", toRequest, this.address, needed, this.arriving);
            }
            this.requestCredits(toRequest);
        } else {
            logger.debug("not asking for {} credits on {}", (Object)toRequest, (Object)this.address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCredits(int credits) {
        logger.debug("Request {} credits on address {}", (Object)credits, (Object)this.address);
        AbstractProducerCreditsImpl abstractProducerCreditsImpl = this;
        synchronized (abstractProducerCreditsImpl) {
            this.pendingCredits += credits;
            this.arriving += credits;
        }
        this.session.sendProducerCreditsMessage(credits, this.address);
    }
}

