/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import org.wildfly.common.Assert;

public final class EJBClientConnection {
    private final URI destination;
    private final boolean forDiscovery;

    EJBClientConnection(Builder builder) {
        this.destination = builder.destination;
        this.forDiscovery = builder.forDiscovery;
    }

    public URI getDestination() {
        return this.destination;
    }

    public boolean isForDiscovery() {
        return this.forDiscovery;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EJBClientConnection(destination=");
        stringBuilder.append(this.destination);
        stringBuilder.append(", for discovery=");
        stringBuilder.append(this.forDiscovery);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static final class Builder {
        URI destination;
        boolean forDiscovery = true;

        public Builder setDestination(URI destination) {
            Assert.checkNotNullParam("destination", destination);
            this.destination = destination;
            return this;
        }

        public Builder setForDiscovery(boolean forDiscovery) {
            this.forDiscovery = forDiscovery;
            return this;
        }

        public EJBClientConnection build() {
            Assert.checkNotNullParam("destination", this.destination);
            return new EJBClientConnection(this);
        }
    }
}

