/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.logging.Logger;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.core.instmgr.InstMgrCandidateStatus;
import org.wildfly.core.instmgr.InstMgrConstants;
import org.wildfly.core.instmgr.logging.InstMgrLogger;

class InstMgrService
implements Service {
    private static final Logger LOG = Logger.getLogger(InstMgrService.class);
    private final Supplier<PathManager> pathManagerSupplier;
    private final Consumer<InstMgrService> consumer;
    private final Supplier<ExecutorService> executorSupplier;
    private PathManager pathManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Path homeDir;
    private Path customPatchPath;
    private Path prepareServerPath;
    private Path controllerTempDir;
    private final ConcurrentMap<String, Path> tempDirs = new ConcurrentHashMap<String, Path>();
    private final InstMgrCandidateStatus candidateStatus;
    private ExecutorService executor;

    InstMgrService(Supplier<PathManager> pathManagerSupplier, Supplier<ExecutorService> executorSupplier, Consumer<InstMgrService> consumer) {
        this.pathManagerSupplier = pathManagerSupplier;
        this.candidateStatus = new InstMgrCandidateStatus();
        this.executorSupplier = executorSupplier;
        this.consumer = consumer;
    }

    public void start(StartContext startContext) throws StartException {
        this.pathManager = this.pathManagerSupplier.get();
        this.executor = this.executorSupplier.get();
        this.homeDir = Path.of(this.pathManager.getPathEntry("jboss.home.dir").resolvePath(), new String[0]);
        this.controllerTempDir = Paths.get(this.pathManager.getPathEntry("jboss.controller.temp.dir").resolvePath(), new String[0]);
        this.prepareServerPath = this.controllerTempDir.resolve(InstMgrConstants.PREPARED_SERVER_SUBPATH);
        this.customPatchPath = this.homeDir.resolve(InstMgrConstants.CUSTOM_PATCH_SUBPATH);
        Path propertiesPath = this.homeDir.resolve("bin").resolve("installation-manager.properties");
        this.candidateStatus.initialize(propertiesPath, this.prepareServerPath);
        try {
            if (this.candidateStatus.getStatus() == InstMgrCandidateStatus.Status.PREPARING) {
                this.candidateStatus.setFailed();
            }
            Files.createDirectories(this.prepareServerPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
        this.started.set(true);
        this.consumer.accept(this);
    }

    public void stop(StopContext context) {
        this.started.set(false);
        this.pathManager = null;
        try {
            this.deleteTempDirs();
        }
        catch (IOException e) {
            InstMgrLogger.ROOT_LOGGER.error(e);
        }
        this.consumer.accept(null);
    }

    Path createTempDir(String workDirPrefix) throws IOException {
        Path tempDirectory = Files.createTempDirectory(workDirPrefix, new FileAttribute[0]);
        this.tempDirs.put(tempDirectory.getFileName().toString(), tempDirectory);
        return tempDirectory;
    }

    Path getTempDirByName(String workDirName) {
        return (Path)this.tempDirs.get(workDirName);
    }

    void deleteTempDirs() throws IOException {
        Iterator it = this.tempDirs.entrySet().iterator();
        while (it.hasNext()) {
            Path workDir = (Path)it.next().getValue();
            try (Stream<Path> walk = Files.walk(workDir, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            it.remove();
        }
    }

    void deleteTempDir(Path tempDirPath) throws IOException {
        if (tempDirPath == null) {
            return;
        }
        this.deleteTempDir(tempDirPath.getFileName().toString());
    }

    void deleteTempDir(String tempDirName) throws IOException {
        if (tempDirName == null) {
            return;
        }
        Path dirToClean = (Path)this.tempDirs.get(tempDirName);
        this.tempDirs.remove(tempDirName);
        if (dirToClean != null && dirToClean.toFile().exists()) {
            try (Stream<Path> walk = Files.walk(dirToClean, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    private void checkStarted() throws IllegalStateException {
        if (!this.started.get()) {
            throw InstMgrLogger.ROOT_LOGGER.installationManagerServiceDown();
        }
    }

    Path getHomeDir() throws IllegalStateException {
        this.checkStarted();
        return this.homeDir;
    }

    Path getCustomPatchDir(String manifestGav) throws IllegalStateException {
        this.checkStarted();
        return this.customPatchPath.resolve(manifestGav);
    }

    Path getPreparedServerDir() throws IllegalStateException {
        this.checkStarted();
        return this.prepareServerPath;
    }

    boolean canPrepareServer() {
        try {
            return this.candidateStatus.getStatus() == InstMgrCandidateStatus.Status.CLEAN;
        }
        catch (IOException e) {
            LOG.debug((Object)"Cannot load the prepared server status from a properties file", (Throwable)e);
            return false;
        }
    }

    void beginCandidateServer() throws IOException {
        this.candidateStatus.begin();
    }

    void commitCandidateServer(String command) throws IOException {
        this.candidateStatus.commit(command);
    }

    void resetCandidateStatus() throws IOException {
        this.candidateStatus.reset();
    }

    InstMgrCandidateStatus.Status getCandidateStatus() throws IOException {
        return this.candidateStatus.getStatus();
    }

    Path getControllerTempDir() {
        this.checkStarted();
        return this.controllerTempDir;
    }

    public ExecutorService getMgmtExecutor() {
        return this.executor;
    }
}

