/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr.cli;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandException;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.instmgr.InstMgrListUpdatesHandler;
import org.wildfly.core.instmgr.cli.AbstractInstMgrCommand;

public class ListUpdatesAction
extends AbstractInstMgrCommand {
    private final List<File> mavenRepoFiles;
    private final List<String> repositories;
    private final Path localCache;
    private final boolean noResolveLocalCache;
    private final boolean offline;
    private final ModelNode headers;

    public ListUpdatesAction(Builder builder) {
        this.mavenRepoFiles = builder.mavenRepoFiles;
        this.repositories = builder.repositories;
        this.localCache = builder.localCache;
        this.noResolveLocalCache = builder.noResolveLocalCache;
        this.offline = builder.offline;
        this.headers = builder.headers;
    }

    @Override
    protected Operation buildOperation() throws CommandException {
        ModelNode op = new ModelNode();
        OperationBuilder operationBuilder = OperationBuilder.create((ModelNode)op);
        op.get("operation").set(InstMgrListUpdatesHandler.DEFINITION.getName());
        if (this.mavenRepoFiles != null && !this.mavenRepoFiles.isEmpty()) {
            ModelNode filesMn = new ModelNode().addEmptyList();
            for (int i = 0; i < this.mavenRepoFiles.size(); ++i) {
                filesMn.add(i);
                operationBuilder.addFileAsAttachment(this.mavenRepoFiles.get(i));
            }
            op.get("maven-repo-files").set(filesMn);
        }
        ListUpdatesAction.addRepositoriesToModelNode(op, this.repositories);
        if (this.localCache != null) {
            op.get("local-cache").set(this.localCache.normalize().toAbsolutePath().toString());
        }
        op.get("no-resolve-local-cache").set(this.noResolveLocalCache);
        op.get("offline").set(this.offline);
        if (this.headers != null && this.headers.isDefined()) {
            op.get("operation-headers").set(this.headers);
        }
        return operationBuilder.build();
    }

    public static class Builder {
        public boolean offline = false;
        private ModelNode headers;
        private List<File> mavenRepoFiles;
        private List<String> repositories = new ArrayList<String>();
        private Path localCache;
        private boolean noResolveLocalCache = false;

        public Builder() {
            this.mavenRepoFiles = new ArrayList<File>();
        }

        public Builder setMavenRepoFiles(List<File> mavenRepoFiles) {
            if (mavenRepoFiles != null) {
                this.mavenRepoFiles.addAll(mavenRepoFiles);
            }
            return this;
        }

        public Builder setRepositories(List<String> repositories) {
            if (repositories != null) {
                this.repositories = new ArrayList<String>(repositories);
            }
            return this;
        }

        public Builder setLocalCache(File localCache) {
            if (localCache != null) {
                this.localCache = localCache.toPath();
            }
            return this;
        }

        public Builder setNoResolveLocalCache(boolean noResolveLocalCache) {
            this.noResolveLocalCache = noResolveLocalCache;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setHeaders(ModelNode headers) {
            this.headers = headers;
            return this;
        }

        public ListUpdatesAction build() {
            return new ListUpdatesAction(this);
        }
    }
}

