/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.perf.BenchmarkService;
import org.apache.activemq.artemis.cli.commands.messages.perf.LiveStatistics;
import org.apache.activemq.artemis.cli.commands.messages.perf.MessageListenerBenchmark;
import org.apache.activemq.artemis.cli.commands.messages.perf.MessageListenerBenchmarkBuilder;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosClock;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;
import org.apache.activemq.artemis.cli.commands.messages.perf.PerfCommand;
import picocli.CommandLine;

@CommandLine.Command(name="consumer", description={"Consume messages from a queue."})
public class PerfConsumerCommand
extends PerfCommand {
    @CommandLine.Option(names={"--tx"}, description={"Individually acknowledge each message received. Default: disabled."})
    protected boolean transaction;
    @CommandLine.Option(names={"--shared"}, description={"Create shared subscription. Default: 0."})
    protected int sharedSubscription = 0;
    @CommandLine.Option(names={"--durable"}, description={"Enabled durable subscription. Default: disabled."})
    protected boolean durableSubscription = false;
    @CommandLine.Option(names={"--num-connections"}, description={"Number of connections to be used. Default: same as the total number of consumers."})
    protected int connections = 0;
    @CommandLine.Option(names={"--consumers"}, description={"Number of consumer to use for each generated destination. Default: 1."})
    protected int consumersPerDestination = 1;
    private BenchmarkService benchmark;

    @Override
    protected void onExecuteBenchmark(ConnectionFactory factory, Destination[] jmsDestinations, ActionContext context) throws Exception {
        LiveStatistics statistics;
        MicrosTimeProvider timeProvider = () -> TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        if (MicrosClock.isAvailable()) {
            timeProvider = MicrosClock::now;
        } else {
            context.err.println("Microseconds wall-clock time not available: using System::currentTimeMillis. Add --add-opens=java.base/jdk.internal.misc=ALL-UNNAMED to the JVM parameters to enable it.");
        }
        if (this.connections == 0) {
            this.connections = this.sharedSubscription > 0 ? (this.clientID == null ? this.sharedSubscription * this.consumersPerDestination * jmsDestinations.length : this.sharedSubscription * jmsDestinations.length) : this.consumersPerDestination * jmsDestinations.length;
        }
        boolean warmingUp = this.warmup != 0;
        StringBuilder skratchBuffer = new StringBuilder();
        try (MessageListenerBenchmark benchmark = new MessageListenerBenchmarkBuilder().setClientID(this.getClientID()).setDestinations(jmsDestinations).setFactory(factory).setTransacted(this.transaction).setConsumers(this.consumersPerDestination).setMessageCount(this.messageCount).setConnections(this.connections).setTimeProvider(timeProvider).setSharedSubscription(this.sharedSubscription).setDurableSubscription(this.durableSubscription).createMessageListenerBenchmark();){
            this.benchmark = benchmark;
            benchmark.start();
            long now = System.currentTimeMillis();
            long endWarmup = this.warmup > 0 ? now + TimeUnit.SECONDS.toMillis(this.warmup) : 0L;
            long end = this.duration > 0 ? now + TimeUnit.SECONDS.toMillis(this.duration) : 0L;
            statistics = new LiveStatistics(this.reportFileName, this.hdrFileName, null, benchmark.getListeners());
            LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(1L));
            warmingUp = this.collectAndReportStatisticsWhileRunning(warmingUp, statistics, skratchBuffer, endWarmup, end, benchmark);
        }
        statistics.sampleMetrics(warmingUp);
        skratchBuffer.setLength(0);
        statistics.outSummary(skratchBuffer);
        if (!this.isSilentInput()) {
            context.out.println(skratchBuffer);
        }
        statistics.close();
    }

    @Override
    protected void onInterruptBenchmark() {
        BenchmarkService benchmark = this.benchmark;
        if (benchmark != null) {
            benchmark.close();
        }
    }
}

