/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.HAPolicySynchronizationStatusReadHandler;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;

public class ReplicationPrimaryDefinition
extends PersistentResourceDefinition {
    public static final Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(HAAttributes.CLUSTER_NAME, HAAttributes.GROUP_NAME, HAAttributes.CHECK_FOR_LIVE_SERVER, HAAttributes.INITIAL_REPLICATION_SYNC_TIMEOUT));
    private final boolean registerRuntime;

    public ReplicationPrimaryDefinition(PathElement path, boolean allowSibling, boolean registerRuntime) {
        super(path, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation(path.getKey(), allowSibling, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.registerRuntime = registerRuntime;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
        if (this.registerRuntime) {
            HAPolicySynchronizationStatusReadHandler.registerMasterAttributes(resourceRegistration);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }
}

