/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.config;

import java.util.Map;
import org.infinispan.protostream.WrappedMessageTypeIdMapper;
import org.infinispan.protostream.config.AnnotationConfiguration;
import org.infinispan.protostream.config.impl.ConfigurationImpl;
import org.infinispan.protostream.descriptors.AnnotationElement;

public interface Configuration {
    public static final int DEFAULT_MAX_NESTED_DEPTH = 100;
    public static final String TYPE_ID_ANNOTATION = "TypeId";

    public boolean logOutOfSequenceReads();

    public boolean logOutOfSequenceWrites();

    public int maxNestedMessageDepth();

    public WrappingConfig wrappingConfig();

    public AnnotationsConfig annotationsConfig();

    public static Builder builder() {
        return new ConfigurationImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder setLogOutOfSequenceReads(boolean var1);

        public Builder setLogOutOfSequenceWrites(boolean var1);

        public Builder maxNestedMessageDepth(int var1);

        @Deprecated
        default public Builder setLogUndefinedAnnotations(boolean logUndefinedAnnotations) {
            this.annotationsConfig().setLogUndefinedAnnotations(logUndefinedAnnotations);
            return this;
        }

        public WrappingConfig.Builder wrappingConfig();

        public AnnotationsConfig.Builder annotationsConfig();

        public Configuration build();
    }

    public static interface AnnotationsConfig {
        public boolean logUndefinedAnnotations();

        public Map<String, AnnotationConfiguration> annotations();

        public static interface Builder {
            public Builder setLogUndefinedAnnotations(boolean var1);

            public AnnotationConfiguration.Builder annotation(String var1, AnnotationElement.AnnotationTarget ... var2);

            public Configuration build();
        }
    }

    public static interface WrappingConfig {
        public WrappedMessageTypeIdMapper wrappedMessageTypeIdMapper();

        public static interface Builder {
            public Builder wrappedMessageTypeIdMapper(WrappedMessageTypeIdMapper var1);

            public Configuration build();
        }
    }
}

