/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgentStartContext;

class PojoMassIndexerAgentStartContextImpl
implements PojoMassIndexerAgentStartContext {
    private final ThreadPoolProvider threadPoolProvider;
    private final FailureHandler failureHandler;
    private ScheduledExecutorService scheduledExecutorService;

    PojoMassIndexerAgentStartContextImpl(ThreadPoolProvider threadPoolProvider, FailureHandler failureHandler) {
        this.threadPoolProvider = threadPoolProvider;
        this.failureHandler = failureHandler;
    }

    @Override
    public ScheduledExecutorService scheduledExecutor() {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.threadPoolProvider.newScheduledExecutor(1, "Mass indexing - Mass indexer agent");
        }
        return this.scheduledExecutorService;
    }

    @Override
    public FailureHandler failureHandler() {
        return this.failureHandler;
    }

    public void clear() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }
}

