/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.reactive.messaging.kafka.commit.CheckpointMetadata;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCheckpointCommit;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingState;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.TopicPartition;
import org.eclipse.microprofile.reactive.messaging.Message;

public class DefaultCheckpointMetadata<T>
implements CheckpointMetadata<T> {
    private final TopicPartition topicPartition;
    private final long recordOffset;
    private final KafkaCheckpointCommit.CheckpointState<T> checkpointState;
    private volatile ProcessingState<T> next;
    private volatile boolean persistOnAck;

    public static <S> DefaultCheckpointMetadata<S> fromMessage(Message<?> message) {
        return message.getMetadata().get(DefaultCheckpointMetadata.class).orElse(null);
    }

    public DefaultCheckpointMetadata(TopicPartition topicPartition, long recordOffset, KafkaCheckpointCommit.CheckpointState<T> checkpointState) {
        this.topicPartition = topicPartition;
        this.recordOffset = recordOffset;
        this.checkpointState = checkpointState;
    }

    KafkaCheckpointCommit.CheckpointState<T> getCheckpointState() {
        return this.checkpointState;
    }

    @Override
    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    @Override
    public long getRecordOffset() {
        return this.recordOffset;
    }

    @Override
    public boolean isPersistOnAck() {
        return this.persistOnAck;
    }

    @Override
    public ProcessingState<T> getCurrent() {
        return this.checkpointState.getProcessingState();
    }

    @Override
    public ProcessingState<T> getNext() {
        return this.next;
    }

    @Override
    public T setNext(T state, boolean persistOnAck) {
        return (T)this.transform(this.getCurrent().getState(), (T s) -> state, persistOnAck);
    }

    @Override
    public T setNext(T state) {
        return (T)this.transform(this.getCurrent().getState(), (T s) -> state);
    }

    @Override
    public T transform(Supplier<T> initialStateSupplier, Function<T, T> transformation, boolean persistOnAck) {
        this.persistOnAck = persistOnAck;
        return this.checkpointState.transformState(() -> new ProcessingState(initialStateSupplier.get(), this.getRecordOffset()), state -> {
            this.next = new ProcessingState(transformation.apply(state.getState()), this.getRecordOffset() + 1L);
            return this.next;
        }).getState();
    }

    @Override
    public T transform(T initialState, Function<T, T> transformation, boolean persistOnAck) {
        return (T)this.transform((T)((Supplier<Object>)() -> initialState), transformation, persistOnAck);
    }

    @Override
    public T transform(Supplier<T> initialStateSupplier, Function<T, T> transformation) {
        return (T)this.transform((T)initialStateSupplier, transformation, false);
    }

    @Override
    public T transform(T initialState, Function<T, T> transformation) {
        return (T)this.transform((T)((Supplier<Object>)() -> initialState), transformation, false);
    }
}

