/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation.address;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.federation.FederatedAbstract;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;
import org.apache.activemq.artemis.core.server.federation.address.FederatedAddressConsumerKey;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.Match;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederatedAddress
extends FederatedAbstract
implements ActiveMQServerBindingPlugin,
ActiveMQServerAddressPlugin,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String FEDERATED_QUEUE_PREFIX = "federated";
    public static final SimpleString HDR_HOPS = new SimpleString("_AMQ_Hops");
    private final SimpleString queueNameFormat;
    private final SimpleString filterString;
    private final Set<Matcher> includes;
    private final Set<Matcher> excludes;
    private final FederationAddressPolicyConfiguration config;
    private final Map<DivertBinding, Set<SimpleString>> matchingDiverts = new HashMap<DivertBinding, Set<SimpleString>>();
    private final boolean hasPullConnectionConfig;

    public FederatedAddress(Federation federation, FederationAddressPolicyConfiguration config, ActiveMQServer server, FederationUpstream upstream) {
        super(federation, server, upstream);
        Objects.requireNonNull(config.getName());
        this.config = config;
        this.filterString = config.getMaxHops() == -1 ? null : HDR_HOPS.concat(" IS NULL OR ").concat(HDR_HOPS).concat("<").concat(Integer.toString(config.getMaxHops()));
        this.queueNameFormat = SimpleString.toSimpleString((String)"federated.${federation}.${upstream}.${address}.${routeType}");
        if (config.getIncludes().isEmpty()) {
            this.includes = Collections.emptySet();
        } else {
            this.includes = new HashSet<Matcher>(config.getIncludes().size());
            for (FederationAddressPolicyConfiguration.Matcher include : config.getIncludes()) {
                this.includes.add(new Matcher(include, this.wildcardConfiguration));
            }
        }
        if (config.getExcludes().isEmpty()) {
            this.excludes = Collections.emptySet();
        } else {
            this.excludes = new HashSet<Matcher>(config.getExcludes().size());
            for (FederationAddressPolicyConfiguration.Matcher exclude : config.getExcludes()) {
                this.excludes.add(new Matcher(exclude, this.wildcardConfiguration));
            }
        }
        this.hasPullConnectionConfig = upstream.getConnection().isPull();
    }

    @Override
    public synchronized void start() {
        if (!this.isStarted()) {
            super.start();
            this.server.getPostOffice().getAllBindings().filter(b -> b instanceof QueueBinding || b instanceof DivertBinding).forEach(this::afterAddBinding);
        }
    }

    private void conditionalCreateRemoteConsumer(Queue queue) {
        if (this.server.hasBrokerFederationPlugins()) {
            AtomicBoolean conditionalCreate = new AtomicBoolean(true);
            try {
                this.server.callBrokerFederationPlugins(plugin -> conditionalCreate.set(conditionalCreate.get() && plugin.federatedAddressConditionalCreateConsumer(queue)));
            }
            catch (ActiveMQException t) {
                ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federatedAddressConditionalCreateConsumer", t);
                throw new IllegalStateException(t.getMessage(), t.getCause());
            }
            if (!conditionalCreate.get()) {
                return;
            }
        }
        this.createRemoteConsumer(queue);
    }

    @Override
    public void afterAddAddress(AddressInfo addressInfo, boolean reload) {
        if (this.match(addressInfo)) {
            try {
                this.server.getPostOffice().getDirectBindings(addressInfo.getName()).stream().filter(binding -> binding instanceof DivertBinding).forEach(this::afterAddBinding);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(addressInfo.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterAddBinding(Binding binding) {
        if (binding instanceof QueueBinding) {
            this.conditionalCreateRemoteConsumer(((QueueBinding)binding).getQueue());
            if (this.config.isEnableDivertBindings().booleanValue()) {
                FederatedAddress federatedAddress = this;
                synchronized (federatedAddress) {
                    for (Map.Entry<DivertBinding, Set<SimpleString>> entry : this.matchingDiverts.entrySet()) {
                        if (entry.getValue().contains(((QueueBinding)binding).getQueue().getName())) continue;
                        this.conditionalCreateRemoteConsumer(entry.getKey(), entry.getValue(), (QueueBinding)binding);
                    }
                }
            }
        } else if (this.config.isEnableDivertBindings().booleanValue() && binding instanceof DivertBinding) {
            DivertBinding divertBinding = (DivertBinding)binding;
            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
            FederatedAddress federatedAddress = this;
            synchronized (federatedAddress) {
                if (this.match(addressInfo) && this.matchingDiverts.get(divertBinding) == null) {
                    HashSet matchingQueues = new HashSet();
                    this.matchingDiverts.put(divertBinding, matchingQueues);
                    SimpleString forwardAddress = divertBinding.getDivert().getForwardAddress();
                    try {
                        this.server.getPostOffice().getBindingsForAddress(forwardAddress).getBindings().stream().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(queueBinding -> this.conditionalCreateRemoteConsumer(divertBinding, matchingQueues, (QueueBinding)queueBinding));
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.federationBindingsLookupError(forwardAddress, e);
                    }
                }
            }
        }
    }

    private void conditionalCreateRemoteConsumer(DivertBinding divertBinding, Set<SimpleString> matchingQueues, QueueBinding queueBinding) {
        if (this.server.hasBrokerFederationPlugins()) {
            AtomicBoolean conditionalCreate = new AtomicBoolean(true);
            try {
                this.server.callBrokerFederationPlugins(plugin -> conditionalCreate.set(conditionalCreate.get() && plugin.federatedAddressConditionalCreateDivertConsumer(divertBinding, queueBinding)));
            }
            catch (ActiveMQException t) {
                ActiveMQServerLogger.LOGGER.federationPluginExecutionError("federatedAddressConditionalCreateDivertConsumer", t);
                throw new IllegalStateException(t.getMessage(), t.getCause());
            }
            if (!conditionalCreate.get()) {
                return;
            }
        }
        this.createRemoteConsumer(divertBinding, matchingQueues, queueBinding);
    }

    private void createRemoteConsumer(DivertBinding divertBinding, Set<SimpleString> matchingQueues, QueueBinding queueBinding) {
        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
        if (this.match(addressInfo) && queueBinding.getAddress().equals((Object)divertBinding.getDivert().getForwardAddress()) && matchingQueues.add(queueBinding.getQueue().getName())) {
            FederatedConsumerKey key = this.getKey(addressInfo);
            Transformer transformer = this.getTransformer(this.config.getTransformerRef());
            Transformer addHop = FederatedAddress::addHop;
            this.createRemoteConsumer(key, this.mergeTransformers(addHop, transformer), (ClientSession clientSession) -> this.createRemoteQueue(clientSession, key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeRemoveBinding(SimpleString uniqueName, Transaction tx, boolean deleteData) {
        Binding binding = this.server.getPostOffice().getBinding(uniqueName);
        if (binding instanceof QueueBinding) {
            Queue queue = ((QueueBinding)binding).getQueue();
            this.removeRemoteConsumer(this.getKey(queue));
            if (this.config.isEnableDivertBindings().booleanValue()) {
                FederatedAddress federatedAddress = this;
                synchronized (federatedAddress) {
                    this.matchingDiverts.entrySet().forEach(entry -> {
                        if (((DivertBinding)entry.getKey()).getDivert().getForwardAddress().equals((Object)queue.getAddress())) {
                            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(((DivertBinding)entry.getKey()).getAddress());
                            if (((Set)entry.getValue()).remove(queue.getAddress())) {
                                this.removeRemoteConsumer(this.getKey(addressInfo));
                            }
                        }
                    });
                }
            }
        } else if (this.config.isEnableDivertBindings().booleanValue() && binding instanceof DivertBinding) {
            DivertBinding divertBinding = (DivertBinding)binding;
            SimpleString forwardAddress = divertBinding.getDivert().getForwardAddress();
            FederatedAddress federatedAddress = this;
            synchronized (federatedAddress) {
                Set<SimpleString> matchingQueues = this.matchingDiverts.remove(binding);
                if (matchingQueues != null) {
                    try {
                        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
                        if (addressInfo != null) {
                            this.server.getPostOffice().getBindingsForAddress(forwardAddress).getBindings().stream().filter(b -> b instanceof QueueBinding && matchingQueues.remove(((QueueBinding)b).getQueue().getName())).forEach(queueBinding -> this.removeRemoteConsumer(this.getKey(addressInfo)));
                        }
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.federationBindingsLookupError(forwardAddress, e);
                    }
                }
            }
        }
    }

    public FederationAddressPolicyConfiguration getConfig() {
        return this.config;
    }

    private void createRemoteConsumer(Queue queue) {
        if (this.match(queue)) {
            FederatedConsumerKey key = this.getKey(queue);
            Transformer transformer = this.getTransformer(this.config.getTransformerRef());
            Transformer addHop = FederatedAddress::addHop;
            this.createRemoteConsumer(key, this.mergeTransformers(addHop, transformer), (ClientSession clientSession) -> this.createRemoteQueue(clientSession, key));
        }
    }

    private void createRemoteQueue(ClientSession clientSession, FederatedConsumerKey key) throws ActiveMQException {
        if (!clientSession.queueQuery(key.getQueueName()).isExists()) {
            clientSession.createQueue(new QueueConfiguration(key.getQueueName()).setAddress(key.getAddress()).setRoutingType(key.getRoutingType()).setFilterString(key.getQueueFilterString()).setDurable(Boolean.valueOf(true)).setAutoDelete(Boolean.valueOf(this.config.getAutoDelete() == null ? true : this.config.getAutoDelete())).setAutoDeleteDelay(Long.valueOf(this.config.getAutoDeleteDelay() == null ? TimeUnit.HOURS.toMillis(1L) : this.config.getAutoDeleteDelay().longValue())).setAutoDeleteMessageCount(Long.valueOf(this.config.getAutoDeleteMessageCount() == null ? -1L : this.config.getAutoDeleteMessageCount())).setMaxConsumers(Integer.valueOf(-1)).setPurgeOnNoConsumers(Boolean.valueOf(false)).setAutoCreated(Boolean.valueOf(false)));
        }
    }

    private boolean match(Queue queue) {
        return this.match(queue.getAddress(), queue.getRoutingType());
    }

    private boolean match(AddressInfo addressInfo) {
        return addressInfo != null ? this.match(addressInfo.getName(), addressInfo.getRoutingType()) : false;
    }

    private boolean match(SimpleString address, RoutingType routingType) {
        if (RoutingType.ANYCAST.equals((Object)routingType)) {
            logger.debug("ignoring unsupported ANYCAST address {}", (Object)address);
            return false;
        }
        if (this.hasPullConnectionConfig) {
            logger.debug("ignoring MULTICAST address {} on unsupported pull connection, consumerWindowSize=0 ", (Object)address);
            return false;
        }
        for (Matcher exclude : this.excludes) {
            if (!exclude.test(address.toString())) continue;
            return false;
        }
        if (this.includes.isEmpty()) {
            return true;
        }
        for (Matcher include : this.includes) {
            if (!include.test(address.toString())) continue;
            return true;
        }
        return false;
    }

    private static Message addHop(Message message) {
        if (message != null) {
            int hops = FederatedAddress.toInt(message.getExtraBytesProperty(HDR_HOPS));
            message.putExtraBytesProperty(HDR_HOPS, ByteUtil.intToBytes((int)(++hops)));
        }
        return message;
    }

    private static int toInt(byte[] bytes) {
        if (bytes != null && bytes.length == 4) {
            return ByteUtil.bytesToInt((byte[])bytes);
        }
        return 0;
    }

    private FederatedConsumerKey getKey(Queue queue) {
        return new FederatedAddressConsumerKey(this.federation.getName(), this.upstream.getName(), queue.getAddress(), queue.getRoutingType(), this.queueNameFormat, this.filterString);
    }

    private FederatedConsumerKey getKey(AddressInfo address) {
        return new FederatedAddressConsumerKey(this.federation.getName(), this.upstream.getName(), address.getName(), address.getRoutingType(), this.queueNameFormat, this.filterString);
    }

    public static class Matcher {
        Predicate<String> addressPredicate;

        Matcher(FederationAddressPolicyConfiguration.Matcher config, WildcardConfiguration wildcardConfiguration) {
            if (config.getAddressMatch() != null && !config.getAddressMatch().isEmpty()) {
                this.addressPredicate = new Match<Object>(config.getAddressMatch(), null, wildcardConfiguration).getPattern().asPredicate();
            }
        }

        public boolean test(String address) {
            return this.addressPredicate == null || this.addressPredicate.test(address);
        }
    }
}

