/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyResolver {
    public static final String NULL_KEY_VALUE = "NULL";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final char SOCKET_ADDRESS_DELIMITER = ':';
    private static final String SOCKET_ADDRESS_PREFIX = "/";
    private final KeyType key;
    private volatile Pattern keyFilter;

    public KeyType getKey() {
        return this.key;
    }

    public String getKeyFilter() {
        return this.keyFilter != null ? this.keyFilter.pattern() : null;
    }

    public KeyResolver(KeyType key, String keyFilter) {
        this.key = key;
        this.setKeyFilter(keyFilter);
    }

    public String resolve(Connection connection, String clientID, String username) {
        String keyValue = null;
        switch (this.key) {
            case CLIENT_ID: {
                keyValue = clientID;
                break;
            }
            case SNI_HOST: {
                if (connection == null) break;
                keyValue = connection.getSNIHostName();
                break;
            }
            case SOURCE_IP: {
                if (connection == null || connection.getRemoteAddress() == null) break;
                keyValue = connection.getRemoteAddress();
                boolean hasPrefix = keyValue.startsWith(SOCKET_ADDRESS_PREFIX);
                int delimiterIndex = keyValue.lastIndexOf(58);
                if (!hasPrefix && delimiterIndex <= 0) break;
                keyValue = keyValue.substring(hasPrefix ? SOCKET_ADDRESS_PREFIX.length() : 0, delimiterIndex > 0 ? delimiterIndex : keyValue.length());
                break;
            }
            case USER_NAME: {
                keyValue = username;
                break;
            }
            case ROLE_NAME: {
                Subject subject;
                if (connection == null || connection.getProtocolConnection() == null || (subject = connection.getProtocolConnection().getSubject()) == null) break;
                for (RolePrincipal candidateRole : subject.getPrincipals(RolePrincipal.class)) {
                    String roleName = candidateRole.getName();
                    if (roleName == null) continue;
                    if (this.keyFilter != null) {
                        Matcher keyMatcher = this.keyFilter.matcher(roleName);
                        if (!keyMatcher.find()) continue;
                        keyValue = keyMatcher.group();
                        logger.debug("role match for {} via {}", (Object)roleName, (Object)keyMatcher);
                        return keyValue;
                    }
                    keyValue = roleName;
                    logger.debug("first role match: {}", (Object)roleName);
                    return keyValue;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.key);
            }
        }
        logger.debug("keyValue for {}: {}", (Object)this.key, (Object)keyValue);
        if (keyValue == null) {
            keyValue = NULL_KEY_VALUE;
        } else if (this.keyFilter != null) {
            Matcher keyMatcher = this.keyFilter.matcher(keyValue);
            if (keyMatcher.find()) {
                keyValue = keyMatcher.group();
                logger.debug("keyValue for {} matches filter {}: {}", new Object[]{this.key, this.keyFilter, keyValue});
            } else {
                keyValue = NULL_KEY_VALUE;
                logger.debug("keyValue for {} doesn't matches filter {}", (Object)this.key, (Object)this.keyFilter);
            }
        }
        return keyValue;
    }

    public void setKeyFilter(String regExp) {
        this.keyFilter = regExp == null || regExp.isBlank() ? null : Pattern.compile(regExp);
    }
}

