/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.pools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.core.cluster.DiscoveryEntry;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.server.routing.pools.DiscoveryService;
import org.apache.activemq.artemis.core.server.routing.targets.Target;

public class DiscoveryGroupService
extends DiscoveryService
implements DiscoveryListener {
    private final Target localTarget;
    private final DiscoveryGroupConfiguration config;
    private DiscoveryGroup discoveryGroup;
    private final Map<String, DiscoveryService.Entry> entries = new ConcurrentHashMap<String, DiscoveryService.Entry>();

    public DiscoveryGroupService(Target localTarget, DiscoveryGroupConfiguration config) {
        this.localTarget = localTarget;
        this.config = config;
    }

    public void start() throws Exception {
        this.discoveryGroup = new DiscoveryGroup(this.localTarget.getNodeID(), this.config.getName(), this.config.getRefreshTimeout(), this.config.getBroadcastEndpointFactory(), null);
        this.discoveryGroup.registerListener((DiscoveryListener)this);
        this.discoveryGroup.start();
    }

    public void stop() throws Exception {
        this.discoveryGroup.unregisterListener((DiscoveryListener)this);
        this.discoveryGroup.stop();
        this.entries.clear();
    }

    public boolean isStarted() {
        return this.discoveryGroup.isStarted();
    }

    public void connectorsChanged(List<DiscoveryEntry> newEntries) {
        HashMap<String, DiscoveryService.Entry> oldEntries = new HashMap<String, DiscoveryService.Entry>(this.entries);
        for (DiscoveryEntry newEntry : newEntries) {
            DiscoveryService.Entry oldEntry = (DiscoveryService.Entry)oldEntries.remove(newEntry.getNodeID());
            if (oldEntry == null) {
                DiscoveryService.Entry addingEntry = new DiscoveryService.Entry(this, newEntry.getNodeID(), newEntry.getConnector());
                this.entries.put(addingEntry.getNodeID(), addingEntry);
                this.fireEntryAddedEvent(addingEntry);
                continue;
            }
            if (newEntry.getConnector().equals((Object)oldEntry.getConnector())) continue;
            DiscoveryService.Entry updatingEntry = new DiscoveryService.Entry(this, newEntry.getNodeID(), newEntry.getConnector());
            this.entries.put(updatingEntry.getNodeID(), updatingEntry);
            this.fireEntryUpdatedEvent(oldEntry, updatingEntry);
        }
        oldEntries.forEach((nodeID, entry) -> {
            this.entries.remove(nodeID);
            this.fireEntryRemovedEvent((DiscoveryService.Entry)entry);
        });
    }
}

