/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.model;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.utils.JsonLoader;

public class TokenReview {
    private boolean authenticated;
    private User user;
    private List<String> audiences;

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public User getUser() {
        return this.user;
    }

    public String getUsername() {
        if (this.user == null) {
            return null;
        }
        return this.user.getUsername();
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public static TokenReview fromJsonString(String obj) {
        JsonObject json = JsonLoader.readObject((Reader)new StringReader(obj));
        JsonObject status = json.getJsonObject("status");
        return TokenReview.fromJson(status);
    }

    private static TokenReview fromJson(JsonObject obj) {
        TokenReview t = new TokenReview();
        if (obj == null) {
            return t;
        }
        t.authenticated = obj.getBoolean("authenticated", false);
        t.user = User.fromJson(obj.getJsonObject("user"));
        t.audiences = TokenReview.listFromJson(obj.getJsonArray("audiences"));
        return t;
    }

    private static List<String> listFromJson(JsonArray items) {
        if (items == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(items.getValuesAs(JsonString::getString));
    }

    public static class Extra {
        private List<String> podNames;
        private List<String> podUids;

        public List<String> getPodNames() {
            return this.podNames;
        }

        public List<String> getPodUids() {
            return this.podUids;
        }

        public static Extra fromJson(JsonObject obj) {
            if (obj == null) {
                return null;
            }
            Extra e = new Extra();
            e.podNames = TokenReview.listFromJson(obj.getJsonArray("authentication.kubernetes.io/pod-name"));
            e.podUids = TokenReview.listFromJson(obj.getJsonArray("authentication.kubernetes.io/pod-uid"));
            return e;
        }
    }

    public static class User {
        private String username;
        private String uid;
        private List<String> groups;
        private Extra extra;

        public Extra getExtra() {
            return this.extra;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public String getUid() {
            return this.uid;
        }

        public String getUsername() {
            return this.username;
        }

        public static User fromJson(JsonObject obj) {
            if (obj == null) {
                return null;
            }
            User u = new User();
            u.username = obj.getString("username", null);
            u.uid = obj.getString("uid", null);
            u.groups = TokenReview.listFromJson(obj.getJsonArray("groups"));
            u.extra = Extra.fromJson(obj.getJsonObject("extra"));
            return u;
        }
    }
}

