/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.builders.CollectionBasedMulti;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Function;

public class MultiCombine {
    private MultiCombine() {
    }

    public static <T> Multi<T> merge(List<Flow.Publisher<T>> participants, boolean collectFailures, int requests, int concurrency) {
        List<Flow.Publisher<T>> candidates = ParameterValidation.doesNotContainNull(participants, "participants");
        if (participants.isEmpty()) {
            return Multi.createFrom().empty();
        }
        if (participants.size() == 1) {
            return Multi.createFrom().publisher(participants.get(0));
        }
        if (collectFailures) {
            return Infrastructure.onMultiCreation(new CollectionBasedMulti<Flow.Publisher<T>>(candidates).onItem().transformToMulti(Function.identity()).collectFailures().withRequests(requests).merge(concurrency));
        }
        return Infrastructure.onMultiCreation(new CollectionBasedMulti<Flow.Publisher<T>>(candidates).onItem().transformToMulti(Function.identity()).withRequests(requests).merge(concurrency));
    }
}

