/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.CipherAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.DigestAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PlainAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public enum XMLElement {
    UNKNOWN(""),
    AUTH_PROTOCOL("auth-protocol"),
    CIPHER_TOKEN("cipher-token"),
    CHANNEL(ChannelResourceDefinition.WILDCARD_PATH),
    CHANNELS("channels"),
    DEFAULT_THREAD_POOL("default-thread-pool"),
    DIGEST_TOKEN("digest-token"),
    ENCRYPT_PROTOCOL("encrypt-protocol"),
    FORK(ForkResourceDefinition.WILDCARD_PATH),
    INTERNAL_THREAD_POOL("internal-thread-pool"),
    JDBC_PROTOCOL("jdbc-protocol"),
    KEY_CREDENTIAL_REFERENCE(EncryptProtocolResourceDefinition.Attribute.KEY_CREDENTIAL),
    OOB_THREAD_POOL("oob-thread-pool"),
    PLAIN_TOKEN("plain-token"),
    PROPERTY("property"),
    PROTOCOL(ProtocolResourceDefinition.WILDCARD_PATH),
    RELAY(RelayResourceDefinition.WILDCARD_PATH),
    REMOTE_SITE(RemoteSiteResourceDefinition.WILDCARD_PATH),
    SHARED_SECRET_CREDENTIAL_REFERENCE(AuthTokenResourceDefinition.Attribute.SHARED_SECRET),
    SOCKET_PROTOCOL("socket-protocol"),
    SOCKET_DISCOVERY_PROTOCOL("socket-discovery-protocol"),
    STACK(StackResourceDefinition.WILDCARD_PATH),
    STACKS("stacks"),
    TIMER_THREAD_POOL("timer-thread-pool"),
    TRANSPORT(TransportResourceDefinition.WILDCARD_PATH);

    private final String name;
    private static final Map<String, XMLElement> elements;
    private static final Map<String, Function<ModelNode, XMLElement>> protocols;
    private static final Map<String, XMLElement> tokens;

    private XMLElement(PathElement path) {
        this.name = path.isWildcard() ? path.getKey() : path.getValue();
    }

    private XMLElement(Attribute attribute) {
        this.name = attribute.getName();
    }

    private XMLElement(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static XMLElement forName(String localName) {
        return elements.getOrDefault(localName, UNKNOWN);
    }

    public static XMLElement forProtocolName(Property protocol) {
        return protocols.getOrDefault(protocol.getName(), XMLElementFunction.PROTOCOL).apply(protocol.getValue());
    }

    public static XMLElement forAuthTokenName(String token) {
        XMLElement element = tokens.get(token);
        if (element == null) {
            throw new IllegalArgumentException(token);
        }
        return element;
    }

    static {
        elements = new HashMap<String, XMLElement>();
        protocols = new HashMap<String, Function<ModelNode, XMLElement>>();
        tokens = new HashMap<String, XMLElement>();
        for (XMLElement element : XMLElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            elements.put(name, element);
        }
        Function<ModelNode, XMLElement> function = new Function<ModelNode, XMLElement>(){

            @Override
            public XMLElement apply(ModelNode model) {
                return model.hasDefined(SocketProtocolResourceDefinition.Attribute.SOCKET_BINDING.getName()) ? SOCKET_PROTOCOL : PROTOCOL;
            }
        };
        for (ProtocolResourceRegistrar.SocketProtocol protocol : EnumSet.allOf(ProtocolResourceRegistrar.SocketProtocol.class)) {
            protocols.put(protocol.name(), function);
        }
        for (ProtocolResourceRegistrar.MulticastProtocol protocol : EnumSet.allOf(ProtocolResourceRegistrar.MulticastProtocol.class)) {
            protocols.put(protocol.name(), XMLElementFunction.SOCKET_PROTOCOL);
        }
        for (ProtocolResourceRegistrar.JdbcProtocol protocol : EnumSet.allOf(ProtocolResourceRegistrar.JdbcProtocol.class)) {
            protocols.put(protocol.name(), XMLElementFunction.JDBC_PROTOCOL);
        }
        for (ProtocolResourceRegistrar.EncryptProtocol protocol : EnumSet.allOf(ProtocolResourceRegistrar.EncryptProtocol.class)) {
            protocols.put(protocol.name(), XMLElementFunction.ENCRYPT_PROTOCOL);
        }
        for (ProtocolResourceRegistrar.InitialHostsProtocol protocol : EnumSet.allOf(ProtocolResourceRegistrar.InitialHostsProtocol.class)) {
            protocols.put(protocol.name(), XMLElementFunction.SOCKET_DISCOVERY_PROTOCOL);
        }
        for (ProtocolResourceRegistrar.AuthProtocol protocol : EnumSet.allOf(ProtocolResourceRegistrar.AuthProtocol.class)) {
            protocols.put(protocol.name(), XMLElementFunction.AUTH_PROTOCOL);
        }
        tokens.put(PlainAuthTokenResourceDefinition.PATH.getValue(), PLAIN_TOKEN);
        tokens.put(DigestAuthTokenResourceDefinition.PATH.getValue(), DIGEST_TOKEN);
        tokens.put(CipherAuthTokenResourceDefinition.PATH.getValue(), CIPHER_TOKEN);
    }

    private static enum XMLElementFunction implements Function<ModelNode, XMLElement>
    {
        PROTOCOL(PROTOCOL),
        SOCKET_PROTOCOL(SOCKET_PROTOCOL),
        JDBC_PROTOCOL(JDBC_PROTOCOL),
        ENCRYPT_PROTOCOL(ENCRYPT_PROTOCOL),
        SOCKET_DISCOVERY_PROTOCOL(SOCKET_DISCOVERY_PROTOCOL),
        AUTH_PROTOCOL(AUTH_PROTOCOL);

        private final XMLElement element;

        private XMLElementFunction(XMLElement element) {
            this.element = element;
        }

        @Override
        public XMLElement apply(ModelNode ignored) {
            return this.element;
        }
    }
}

