/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.InputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.repository.TypedInputStream;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class ManagedDeploymentReadContentHandler
implements OperationStepHandler {
    protected final ContentRepository contentRepository;

    public ManagedDeploymentReadContentHandler(ContentRepository contentRepository) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getProcessType() == ProcessType.SELF_CONTAINED) {
            throw ServerLogger.ROOT_LOGGER.cannotReadContentFromSelfContainedServer();
        }
        Resource deploymentResource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItemNode = DeploymentHandlerUtil.getContentItem(deploymentResource);
        if (!DeploymentHandlerUtil.isManaged(contentItemNode)) {
            throw ServerLogger.ROOT_LOGGER.cannotReadContentFromUnmanagedDeployment();
        }
        byte[] deploymentHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItemNode).asBytes();
        ModelNode contentPath = DeploymentAttributes.CONTENT_PATH.resolveModelAttribute(context, operation);
        String path = contentPath.isDefined() ? contentPath.asString() : "";
        try {
            TypedInputStream inputStream = this.contentRepository.readContent(deploymentHash, path);
            String uuid = context.attachResultStream(inputStream.getContentType(), (InputStream)inputStream);
            context.getResult().get("uuid").set(uuid);
        }
        catch (ExplodedContentException ex) {
            throw DeploymentHandlerUtils.createFailureException(ex.toString());
        }
    }
}

