/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.DelegatingClassTransformer;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.ClassTransformer;
import org.jboss.modules.Module;

public class ClassTransformerProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DelegatingClassTransformer transformer = deploymentUnit.getAttachment(DelegatingClassTransformer.ATTACHMENT_KEY);
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        Module module = deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null || transformer == null) {
            return;
        }
        try {
            for (String transformerClassName : moduleSpecification.getClassTransformers()) {
                transformer.addTransformer((ClassTransformer)module.getClassLoader().loadClass(transformerClassName).newInstance());
            }
            transformer.setActive(true);
        }
        catch (Exception e) {
            throw ServerLogger.ROOT_LOGGER.failedToInstantiateClassTransformer(ClassTransformer.class.getSimpleName(), e);
        }
    }
}

