/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.storage.ReplayCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OneTimeUseConditionValidator
implements ConditionValidator {
    @Nonnull
    @NotEmpty
    public static final String CACHE_CONTEXT = OneTimeUseConditionValidator.class.getName();
    @Nonnull
    private Logger log = LoggerFactory.getLogger(OneTimeUseConditionValidator.class);
    @Nonnull
    private final ReplayCache replayCache;
    @Nonnull
    private Duration replayCacheExpires;

    public OneTimeUseConditionValidator(@Nonnull ReplayCache replay, @Nullable Duration expires) {
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)replay, (String)"Replay cache was null");
        this.replayCacheExpires = expires;
        if (this.replayCacheExpires == null) {
            this.replayCacheExpires = Duration.ofHours(8L);
        } else if (this.replayCacheExpires.isNegative()) {
            this.log.warn("Supplied value for replay cache expires '{}' was negative, using default expiration", (Object)this.replayCacheExpires);
            this.replayCacheExpires = Duration.ofHours(8L);
        }
    }

    @Nonnull
    public QName getServicedCondition() {
        return OneTimeUse.DEFAULT_ELEMENT_NAME;
    }

    @Nonnull
    public ValidationResult validate(@Nonnull Condition condition, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        if (!(condition instanceof OneTimeUse) && !Objects.equals(condition.getElementQName(), this.getServicedCondition())) {
            this.log.warn("Condition '{}' of type '{}' in assertion '{}' was not an '{}' condition.  Unable to process.", new Object[]{condition.getElementQName(), condition.getSchemaType(), assertion.getID(), this.getServicedCondition()});
            return ValidationResult.INDETERMINATE;
        }
        if (!this.replayCache.check(CACHE_CONTEXT, this.getCacheValue(assertion), this.getExpires(assertion, context))) {
            context.setValidationFailureMessage(String.format("Assertion '%s' has a one time use condition and has been used before", assertion.getID()));
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    @Nonnull
    protected Duration getReplayCacheExpires() {
        return this.replayCacheExpires;
    }

    @Nonnull
    protected Instant getExpires(Assertion assertion, ValidationContext context) {
        Duration expires = null;
        Object raw = context.getStaticParameters().get("saml2.Conditions.OneTimeUseExpires");
        if (raw instanceof Duration) {
            expires = (Duration)raw;
        } else if (raw instanceof Long) {
            expires = Duration.ofMillis((Long)raw);
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"saml2.Conditions.OneTimeUseExpires", null, (String)Duration.class.getName());
        }
        this.log.debug("Saw one-time use cache expires context param: {}", (Object)expires);
        Duration suppliedExpiration = null;
        if (expires == null || expires.isZero()) {
            suppliedExpiration = this.getReplayCacheExpires();
        } else if (expires.isNegative()) {
            this.log.warn("Supplied context param for replay cache expires '{}' was negative, using configured expiration", (Object)expires);
            suppliedExpiration = this.getReplayCacheExpires();
        } else {
            suppliedExpiration = expires;
        }
        this.log.debug("Effective one-time use cache expires of: {}", (Object)suppliedExpiration);
        Instant computedExpiration = Instant.now().plus(suppliedExpiration);
        this.log.debug("Computed one-time use cache effective expiration time of: {}", (Object)computedExpiration);
        return computedExpiration;
    }

    @Nonnull
    protected String getCacheValue(@Nonnull Assertion assertion) throws AssertionValidationException {
        String id;
        String issuer = null;
        if (assertion.getIssuer() != null && assertion.getIssuer().getValue() != null) {
            issuer = StringSupport.trimOrNull((String)assertion.getIssuer().getValue());
        }
        if (issuer == null) {
            issuer = "NoIssuer";
        }
        if ((id = StringSupport.trimOrNull((String)assertion.getID())) == null) {
            id = "NoID";
        }
        String value = String.format("%s--%s", issuer, id);
        this.log.debug("Generated one-time use cache value of: {}", (Object)value);
        return value;
    }
}

