/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public class JcePGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private final int encAlgorithm;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.helper);
    private SecureRandom random;
    private boolean withIntegrityPacket = true;
    private int aeadAlgorithm = -1;
    private int chunkSize;
    private boolean isV5StyleAEAD = true;

    public JcePGPDataEncryptorBuilder(int n) {
        this.encAlgorithm = n;
        if (n == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    @Override
    public JcePGPDataEncryptorBuilder setWithIntegrityPacket(boolean bl) {
        this.withIntegrityPacket = bl;
        return this;
    }

    @Override
    public JcePGPDataEncryptorBuilder setWithAEAD(int n, int n2) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES");
        }
        if (n2 < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = n;
        this.chunkSize = n2 - 6;
        return this;
    }

    @Override
    public JcePGPDataEncryptorBuilder setUseV5AEAD() {
        this.isV5StyleAEAD = true;
        return this;
    }

    @Override
    public JcePGPDataEncryptorBuilder setUseV6AEAD() {
        this.isV5StyleAEAD = false;
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePGPDataEncryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.aeadHelper = new JceAEADUtil(this.helper);
        return this;
    }

    public JcePGPDataEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    @Override
    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean isV5StyleAEAD() {
        return this.isV5StyleAEAD;
    }

    @Override
    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    @Override
    public PGPDataEncryptor build(byte[] byArray) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(byArray);
        }
        return new MyPGPDataEncryptor(byArray);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final boolean isV5StyleAEAD;
        private final Cipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] byArray) throws PGPException {
            boolean bl = this.isV5StyleAEAD = byArray.length == SymmetricKeyUtils.getKeyLengthInOctets(JcePGPDataEncryptorBuilder.this.encAlgorithm);
            if (this.isV5StyleAEAD) {
                this.keyBytes = byArray;
                this.iv = new byte[AEADUtils.getIVLength((byte)JcePGPDataEncryptorBuilder.this.aeadAlgorithm)];
                JcePGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
            } else {
                byte[][] byArray2 = AEADUtils.splitMessageKeyAndIv(byArray, JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm);
                this.keyBytes = byArray2[0];
                this.iv = byArray2[1];
            }
            this.c = JcePGPDataEncryptorBuilder.this.aeadHelper.createAEADCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm);
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            try {
                return new JceAEADUtil.PGPAeadOutputStream(this.isV5StyleAEAD, outputStream, this.c, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, this.keyBytes), this.iv, JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.aeadAlgorithm, JcePGPDataEncryptorBuilder.this.chunkSize);
            }
            catch (Exception exception) {
                throw new IllegalStateException("unable to process stream: " + exception.getMessage());
            }
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }

        @Override
        public int getAEADAlgorithm() {
            return JcePGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        @Override
        public int getChunkSize() {
            return JcePGPDataEncryptorBuilder.this.chunkSize;
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone((byte[])this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final Cipher c;

        MyPGPDataEncryptor(byte[] byArray) throws PGPException {
            this.c = JcePGPDataEncryptorBuilder.this.helper.createStreamCipher(JcePGPDataEncryptorBuilder.this.encAlgorithm, JcePGPDataEncryptorBuilder.this.withIntegrityPacket);
            try {
                if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                    byte[] byArray2 = new byte[this.c.getBlockSize()];
                    this.c.init(1, (Key)JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, byArray), new IvParameterSpec(byArray2));
                } else {
                    this.c.init(1, JcaJcePGPUtil.makeSymmetricKey(JcePGPDataEncryptorBuilder.this.encAlgorithm, byArray));
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new PGPException("imvalid algorithm parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.c);
        }

        @Override
        public PGPDigestCalculator getIntegrityCalculator() {
            if (JcePGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

