/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.clustering;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ejb3.clustering.ClusteringSchema;
import org.jboss.as.ejb3.clustering.EJBBoundClusteringMetaData;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaData;
import org.jboss.metadata.ejb.parser.jboss.ejb3.AbstractEJBBoundMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.Versioned;

public class EJBBoundClusteringMetaDataParser
extends AbstractEJBBoundMetaDataParser<EJBBoundClusteringMetaData> {
    private final ClusteringSchema schema;

    public EJBBoundClusteringMetaDataParser(ClusteringSchema schema) {
        this.schema = schema;
    }

    public EJBBoundClusteringMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (!reader.getLocalName().equals("clustering")) {
            throw EJBBoundClusteringMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        if (this.schema != ClusteringSchema.CURRENT) {
            EjbLogger.ROOT_LOGGER.deprecatedNamespace(reader.getNamespaceURI(), reader.getLocalName());
        }
        EJBBoundClusteringMetaData metaData = new EJBBoundClusteringMetaData();
        this.processElements(metaData, reader, propertyReplacer);
        return metaData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processElement(EJBBoundClusteringMetaData metaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        if (this.schema.getNamespace().getUri().equals(reader.getNamespaceURI())) {
            switch (reader.getLocalName()) {
                case "clustered": {
                    if (this.schema.since((Versioned)ClusteringSchema.VERSION_1_1)) {
                        throw EJBBoundClusteringMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                    }
                    reader.getElementText();
                    return;
                }
                case "clustered-singleton": {
                    if (!this.schema.since((Versioned)ClusteringSchema.VERSION_1_1)) throw EJBBoundClusteringMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                    EJBBoundClusteringMetaDataParser.requireNoAttributes((XMLStreamReader)reader);
                    String text = EJBBoundClusteringMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                    if (text == null) return;
                    boolean isClusteredSingleton = Boolean.parseBoolean(text.trim());
                    metaData.setClusteredSingleton(isClusteredSingleton);
                    return;
                }
                default: {
                    throw EJBBoundClusteringMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
        } else {
            super.processElement((AbstractEJBBoundMetaData)metaData, reader, propertyReplacer);
        }
    }
}

