/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexFieldReference;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexCompositeNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeCollector;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexCompositeNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexField;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexValueField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class LuceneIndexValueFieldBuilder<F>
implements IndexSchemaFieldOptionsStep<LuceneIndexValueFieldBuilder<F>, IndexFieldReference<F>>,
LuceneIndexNodeContributor,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractLuceneIndexCompositeNodeBuilder parent;
    private final String relativeFieldName;
    private final String absoluteFieldPath;
    private final TreeNodeInclusion inclusion;
    private final LuceneIndexValueFieldType<F> type;
    private boolean multiValued = false;
    private LuceneIndexFieldReference<F> reference;

    LuceneIndexValueFieldBuilder(AbstractLuceneIndexCompositeNodeBuilder parent, String relativeFieldName, TreeNodeInclusion inclusion, LuceneIndexValueFieldType<F> type) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)relativeFieldName);
        this.inclusion = inclusion;
        this.type = type;
    }

    public EventContext eventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public LuceneIndexValueFieldBuilder<F> multiValued() {
        this.multiValued = true;
        return this;
    }

    public IndexFieldReference<F> toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new LuceneIndexFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(LuceneIndexNodeCollector collector, LuceneIndexCompositeNode parentNode, Map<String, LuceneIndexField> staticChildrenByNameForParent) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.eventContext());
        }
        LuceneIndexValueField<F> fieldNode = new LuceneIndexValueField<F>(parentNode, this.relativeFieldName, this.type, this.inclusion, this.multiValued, false);
        staticChildrenByNameForParent.put(this.relativeFieldName, fieldNode);
        collector.collect(fieldNode.absolutePath(), fieldNode);
        this.reference.setSchemaNode(fieldNode);
    }
}

