/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldContributor;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldValueExtractor;
import org.hibernate.search.backend.lucene.types.dsl.LuceneIndexFieldTypeFactory;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneBigDecimalIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneBigIntegerIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneBooleanIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneByteIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneDoubleIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneFloatIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneGeoPointIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneInstantIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIntegerIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLocalDateIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLocalDateTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLocalTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneLongIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneMonthDayIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneNativeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneOffsetDateTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneOffsetTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneShortIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneStringIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneYearIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneYearMonthIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneZonedDateTimeIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.mapping.spi.BackendMapperContext;
import org.hibernate.search.engine.backend.reporting.spi.BackendMappingHints;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StandardIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneIndexFieldTypeFactoryImpl
implements LuceneIndexFieldTypeFactory,
LuceneIndexFieldTypeBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final EventContext eventContext;
    private final BackendMapperContext backendMapperContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final IndexFieldTypeDefaultsProvider typeDefaultsProvider;

    public LuceneIndexFieldTypeFactoryImpl(EventContext eventContext, BackendMapperContext backendMapperContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, IndexFieldTypeDefaultsProvider typeDefaultsProvider) {
        this.eventContext = eventContext;
        this.backendMapperContext = backendMapperContext;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.typeDefaultsProvider = typeDefaultsProvider;
    }

    public <F> StandardIndexFieldTypeOptionsStep<?, F> as(Class<F> valueType) {
        if (String.class.equals(valueType)) {
            return this.asString();
        }
        if (Integer.class.equals(valueType)) {
            return this.asInteger();
        }
        if (Long.class.equals(valueType)) {
            return this.asLong();
        }
        if (Boolean.class.equals(valueType)) {
            return this.asBoolean();
        }
        if (Byte.class.equals(valueType)) {
            return this.asByte();
        }
        if (Short.class.equals(valueType)) {
            return this.asShort();
        }
        if (Float.class.equals(valueType)) {
            return this.asFloat();
        }
        if (Double.class.equals(valueType)) {
            return this.asDouble();
        }
        if (LocalDate.class.equals(valueType)) {
            return this.asLocalDate();
        }
        if (LocalDateTime.class.equals(valueType)) {
            return this.asLocalDateTime();
        }
        if (LocalTime.class.equals(valueType)) {
            return this.asLocalTime();
        }
        if (Instant.class.equals(valueType)) {
            return this.asInstant();
        }
        if (ZonedDateTime.class.equals(valueType)) {
            return this.asZonedDateTime();
        }
        if (Year.class.equals(valueType)) {
            return this.asYear();
        }
        if (YearMonth.class.equals(valueType)) {
            return this.asYearMonth();
        }
        if (MonthDay.class.equals(valueType)) {
            return this.asMonthDay();
        }
        if (OffsetDateTime.class.equals(valueType)) {
            return this.asOffsetDateTime();
        }
        if (OffsetTime.class.equals(valueType)) {
            return this.asOffsetTime();
        }
        if (GeoPoint.class.equals(valueType)) {
            return this.asGeoPoint();
        }
        if (BigDecimal.class.equals(valueType)) {
            return this.asBigDecimal();
        }
        if (BigInteger.class.equals(valueType)) {
            return this.asBigInteger();
        }
        throw log.cannotGuessFieldType(valueType, this.getEventContext());
    }

    public StringIndexFieldTypeOptionsStep<?> asString() {
        return new LuceneStringIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Integer> asInteger() {
        return new LuceneIntegerIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Long> asLong() {
        return new LuceneLongIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Boolean> asBoolean() {
        return new LuceneBooleanIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Byte> asByte() {
        return new LuceneByteIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Short> asShort() {
        return new LuceneShortIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Float> asFloat() {
        return new LuceneFloatIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Double> asDouble() {
        return new LuceneDoubleIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, LocalDate> asLocalDate() {
        return new LuceneLocalDateIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, LocalDateTime> asLocalDateTime() {
        return new LuceneLocalDateTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, LocalTime> asLocalTime() {
        return new LuceneLocalTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Instant> asInstant() {
        return new LuceneInstantIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, ZonedDateTime> asZonedDateTime() {
        return new LuceneZonedDateTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, Year> asYear() {
        return new LuceneYearIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, YearMonth> asYearMonth() {
        return new LuceneYearMonthIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, MonthDay> asMonthDay() {
        return new LuceneMonthDayIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, OffsetDateTime> asOffsetDateTime() {
        return new LuceneOffsetDateTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, OffsetTime> asOffsetTime() {
        return new LuceneOffsetTimeIndexFieldTypeOptionsStep(this);
    }

    public StandardIndexFieldTypeOptionsStep<?, GeoPoint> asGeoPoint() {
        return new LuceneGeoPointIndexFieldTypeOptionsStep(this);
    }

    public ScaledNumberIndexFieldTypeOptionsStep<?, BigDecimal> asBigDecimal() {
        return new LuceneBigDecimalIndexFieldTypeOptionsStep((LuceneIndexFieldTypeBuildContext)this, this.typeDefaultsProvider);
    }

    public ScaledNumberIndexFieldTypeOptionsStep<?, BigInteger> asBigInteger() {
        return new LuceneBigIntegerIndexFieldTypeOptionsStep((LuceneIndexFieldTypeBuildContext)this, this.typeDefaultsProvider);
    }

    @Override
    public <F> IndexFieldTypeOptionsStep<?, F> asNative(Class<F> indexFieldType, LuceneFieldContributor<F> fieldContributor, LuceneFieldValueExtractor<F> fieldValueExtractor) {
        return new LuceneNativeIndexFieldTypeOptionsStep<F>(this, indexFieldType, fieldContributor, fieldValueExtractor);
    }

    @Override
    public EventContext getEventContext() {
        return this.eventContext;
    }

    @Override
    public LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }

    @Override
    public BackendMappingHints hints() {
        return this.backendMapperContext.hints();
    }
}

