/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces.core;

import com.sun.faces.component.behavior.AjaxBehaviors;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.composite.BehaviorHolderWrapper;
import com.sun.faces.facelets.tag.composite.RetargetedAjaxBehavior;
import com.sun.faces.facelets.tag.faces.CompositeComponentTagHandler;
import com.sun.faces.facelets.tag.faces.core.AjaxBehaviorListenerImpl;
import com.sun.faces.renderkit.RenderKitUtils;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.application.Application;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.view.AttachedObjectTarget;
import jakarta.faces.view.BehaviorHolderAttachedObjectHandler;
import jakarta.faces.view.BehaviorHolderAttachedObjectTarget;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.CompositeFaceletHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public final class AjaxHandler
extends TagHandlerImpl
implements BehaviorHolderAttachedObjectHandler {
    private final TagAttribute event = this.getAttribute("event");
    private final TagAttribute execute = this.getAttribute("execute");
    private final TagAttribute render = this.getAttribute("render");
    private final TagAttribute onevent = this.getAttribute("onevent");
    private final TagAttribute onerror = this.getAttribute("onerror");
    private final TagAttribute disabled = this.getAttribute("disabled");
    private final TagAttribute immediate = this.getAttribute("immediate");
    private final TagAttribute resetValues = this.getAttribute("resetValues");
    private final TagAttribute listener = this.getAttribute("listener");
    private final TagAttribute delay = this.getAttribute("delay");
    private final boolean wrapping = this.isWrapping();

    public AjaxHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String eventName = this.getEventName();
        if (this.wrapping) {
            this.applyWrapping(ctx, parent, eventName);
        } else {
            this.applyNested(ctx, parent, eventName);
        }
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        this.applyAttachedObject(ctx, parent, this.getEventName());
    }

    @Override
    public String getFor() {
        return null;
    }

    @Override
    public String getEventName() {
        FacesContext context = FacesContext.getCurrentInstance();
        FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        return this.event != null ? this.event.getValue(ctx) : null;
    }

    private boolean isWrapping() {
        return this.nextHandler instanceof TagHandler || this.nextHandler instanceof CompositeFaceletHandler;
    }

    private void applyWrapping(FaceletContext ctx, UIComponent parent, String eventName) throws IOException {
        RenderKitUtils.installFacesJsIfNecessary(ctx.getFacesContext());
        AjaxBehavior ajaxBehavior = this.createAjaxBehavior(ctx, parent, eventName);
        FacesContext context = ctx.getFacesContext();
        AjaxBehaviors ajaxBehaviors = AjaxBehaviors.getAjaxBehaviors(context, true);
        ajaxBehaviors.pushBehavior(context, ajaxBehavior, eventName);
        this.nextHandler.apply(ctx, parent);
        ajaxBehaviors.popBehavior();
    }

    private void applyNested(FaceletContext ctx, UIComponent parent, String eventName) {
        if (!ComponentHandler.isNew(parent)) {
            return;
        }
        if (UIComponent.isCompositeComponent(parent)) {
            BeanInfo componentBeanInfo;
            boolean tagApplied = false;
            if (parent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(ctx, parent, eventName);
                tagApplied = true;
            }
            if (null == (componentBeanInfo = (BeanInfo)parent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY"))) {
                throw new TagException(this.tag, "Error: enclosing composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.tag, "Error: enclosing composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("jakarta.faces.view.AttachedObjectTargets");
            if (null == targetList && !tagApplied) {
                throw new TagException(this.tag, "Error: enclosing composite component does not support behavior events");
            }
            boolean supportedEvent = false;
            for (AttachedObjectTarget target : targetList) {
                if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                supportedEvent = true;
                break;
            }
            if (supportedEvent) {
                CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add(this);
            } else if (!tagApplied) {
                throw new TagException(this.tag, "Error: enclosing composite component does not support event " + eventName);
            }
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(ctx, parent, eventName);
        } else {
            throw new TagException(this.tag, "Unable to attach <f:ajax> to non-ClientBehaviorHolder parent");
        }
    }

    private void applyAttachedObject(FaceletContext ctx, UIComponent parent, String eventName) {
        ClientBehaviorHolder bHolder = (ClientBehaviorHolder)((Object)parent);
        if (null == eventName) {
            eventName = bHolder.getDefaultEventName();
            if (null == eventName) {
                throw new TagException(this.tag, "Event attribute could not be determined: " + eventName);
            }
        } else {
            Collection<String> eventNames = bHolder.getEventNames();
            if (!eventNames.contains(eventName)) {
                throw new TagException(this.tag, this.getUnsupportedEventMessage(eventName, eventNames, parent));
            }
        }
        AjaxBehavior ajaxBehavior = this.createAjaxBehavior(ctx, parent, eventName);
        bHolder.addClientBehavior(eventName, ajaxBehavior);
        RenderKitUtils.installFacesJsIfNecessary(ctx.getFacesContext());
    }

    private AjaxBehavior createAjaxBehavior(FaceletContext ctx, UIComponent parent, String eventName) {
        ArrayList<String> executeClientIds;
        String targetClientIds;
        ValueExpression targets;
        Application application = ctx.getFacesContext().getApplication();
        AjaxBehavior behavior = (AjaxBehavior)application.createBehavior("jakarta.faces.behavior.Ajax");
        this.setBehaviorAttribute(ctx, behavior, this.onevent, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.onerror, String.class);
        this.setBehaviorAttribute(ctx, behavior, this.disabled, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.immediate, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.resetValues, Boolean.class);
        this.setBehaviorAttribute(ctx, behavior, this.execute, Object.class);
        this.setBehaviorAttribute(ctx, behavior, this.render, Object.class);
        this.setBehaviorAttribute(ctx, behavior, this.delay, String.class);
        if (parent instanceof BehaviorHolderWrapper && (targets = ((BehaviorHolderWrapper)parent).getTargets()) != null && (targetClientIds = (String)targets.getValue((ELContext)ctx)) != null && ((executeClientIds = new ArrayList<String>(behavior.getExecute())).isEmpty() || executeClientIds.contains("@this"))) {
            String separatorChar = String.valueOf(UINamingContainer.getSeparatorChar(ctx.getFacesContext()));
            executeClientIds.remove("@this");
            Arrays.stream(targetClientIds.trim().split(" +")).map(id -> "@this" + separatorChar + id).forEach(executeClientIds::add);
            behavior.setExecute(executeClientIds);
            behavior = new RetargetedAjaxBehavior(behavior);
        }
        if (null != this.listener) {
            behavior.addAjaxBehaviorListener(new AjaxBehaviorListenerImpl(this.listener.getMethodExpression(ctx, Object.class, new Class[]{AjaxBehaviorEvent.class}), this.listener.getMethodExpression(ctx, Object.class, new Class[0])));
        }
        return behavior;
    }

    private void setBehaviorAttribute(FaceletContext ctx, AjaxBehavior behavior, TagAttribute attr, Class<?> type) {
        if (attr != null) {
            behavior.setValueExpression(attr.getLocalName(), attr.getValueExpression(ctx, type));
        }
    }

    private String getUnsupportedEventMessage(String eventName, Collection<String> eventNames, UIComponent parent) {
        StringBuilder builder = new StringBuilder(100);
        builder.append("'");
        builder.append(eventName);
        builder.append("' is not a supported event for ");
        builder.append(parent.getClass().getSimpleName());
        builder.append(".  Please specify one of these supported event names: ");
        TreeSet<String> sortedEventNames = new TreeSet<String>(eventNames);
        Iterator iter = sortedEventNames.iterator();
        boolean hasNext = iter.hasNext();
        while (hasNext) {
            builder.append((String)iter.next());
            hasNext = iter.hasNext();
            if (!hasNext) continue;
            builder.append(", ");
        }
        builder.append(".");
        return builder.toString();
    }
}

