/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoop;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPConnectionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressSenderController;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueueSenderController;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.LinkCloseListener;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ExecutorNettyAdapter;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ExtCapability;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.AnonymousServerSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.protocol.amqp.sasl.PlainSASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPConnectionContext
extends ProtonInitializable
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf((String)"amqp:connection-establishment-failed");
    public static final String AMQP_CONTAINER_ID = "amqp-container-id";
    private static final FutureTask<Void> VOID_FUTURE = new FutureTask<Object>(() -> {}, null);
    protected final ProtonHandler handler;
    private AMQPConnectionCallback connectionCallback;
    private final String containerId;
    private final boolean isIncomingConnection;
    private final ClientSASLFactory saslClientFactory;
    private final Map<Symbol, Object> connectionProperties = new HashMap<Symbol, Object>();
    private final ScheduledExecutorService scheduledPool;
    private final Map<String, LinkCloseListener> linkCloseListeners = new ConcurrentHashMap<String, LinkCloseListener>();
    private final Map<Session, AMQPSessionContext> sessions = new ConcurrentHashMap<Session, AMQPSessionContext>();
    private final ProtonProtocolManager protocolManager;
    private final boolean useCoreSubscriptionNaming;
    private final boolean bridgeConnection;
    private final ScheduleOperator scheduleOp = new ScheduleOperator(new ScheduleRunnable());
    private final AtomicReference<Future<?>> scheduledFutureRef = new AtomicReference<FutureTask<Void>>(VOID_FUTURE);
    private String user;
    private String password;
    private String validatedUser;

    public AMQPConnectionContext(ProtonProtocolManager protocolManager, AMQPConnectionCallback connectionSP, String containerId, int idleTimeout, int maxFrameSize, int channelMax, boolean useCoreSubscriptionNaming, ScheduledExecutorService scheduledPool, boolean isIncomingConnection, ClientSASLFactory saslClientFactory, Map<Symbol, Object> connectionProperties) {
        this(protocolManager, connectionSP, containerId, idleTimeout, maxFrameSize, channelMax, useCoreSubscriptionNaming, scheduledPool, isIncomingConnection, saslClientFactory, connectionProperties, false);
    }

    public AMQPConnectionContext(ProtonProtocolManager protocolManager, AMQPConnectionCallback connectionSP, String containerId, int idleTimeout, int maxFrameSize, int channelMax, boolean useCoreSubscriptionNaming, ScheduledExecutorService scheduledPool, boolean isIncomingConnection, ClientSASLFactory saslClientFactory, Map<Symbol, Object> connectionProperties, boolean bridgeConnection) {
        this.protocolManager = protocolManager;
        this.bridgeConnection = bridgeConnection;
        this.connectionCallback = connectionSP;
        this.useCoreSubscriptionNaming = useCoreSubscriptionNaming;
        this.containerId = containerId != null ? containerId : UUID.randomUUID().toString();
        this.isIncomingConnection = isIncomingConnection;
        this.saslClientFactory = saslClientFactory;
        this.connectionProperties.put(AmqpSupport.PRODUCT, "apache-activemq-artemis");
        this.connectionProperties.put(AmqpSupport.VERSION, VersionLoader.getVersion().getFullVersion());
        if (connectionProperties != null) {
            this.connectionProperties.putAll(connectionProperties);
        }
        this.scheduledPool = scheduledPool;
        this.connectionCallback.setConnection(this);
        Object nettyExecutor = this.connectionCallback.getTransportConnection() instanceof NettyConnection ? ((NettyConnection)this.connectionCallback.getTransportConnection()).getNettyChannel().eventLoop() : new ExecutorNettyAdapter(protocolManager.getServer().getExecutorFactory().getExecutor());
        this.handler = new ProtonHandler((EventLoop)nettyExecutor, protocolManager.getServer().getExecutorFactory().getExecutor(), isIncomingConnection && saslClientFactory == null);
        this.handler.addEventHandler(this);
        Transport transport = this.handler.getTransport();
        transport.setEmitFlowEventOnSend(false);
        if (idleTimeout > 0) {
            transport.setIdleTimeout(idleTimeout);
        }
        transport.setChannelMax(channelMax);
        transport.setInitialRemoteMaxFrameSize(protocolManager.getInitialRemoteMaxFrameSize());
        transport.setMaxFrameSize(maxFrameSize);
        transport.setOutboundFrameSizeLimit(maxFrameSize);
        if (saslClientFactory != null) {
            this.handler.createClientSASL();
        }
    }

    @Override
    public void initialize() throws Exception {
        this.initialized = true;
    }

    public AMQPConnectionContext addLinkRemoteCloseListener(String id, LinkCloseListener linkCloseListener) {
        this.linkCloseListeners.put(id, linkCloseListener);
        return this;
    }

    public void removeLinkRemoteCloseListener(String id) {
        this.linkCloseListeners.remove(id);
    }

    public void clearLinkRemoteCloseListeners() {
        this.linkCloseListeners.clear();
    }

    public boolean isBridgeConnection() {
        return this.bridgeConnection;
    }

    public void requireInHandler() {
        this.handler.requireHandler();
    }

    public boolean isHandler() {
        return this.handler.isHandler();
    }

    public void scheduledFlush() {
        this.handler.scheduledFlush();
    }

    public boolean isIncomingConnection() {
        return this.isIncomingConnection;
    }

    public ClientSASLFactory getSaslClientFactory() {
        return this.saslClientFactory;
    }

    protected AMQPSessionContext newSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AMQPSessionCallback sessionSPI = this.connectionCallback.createSessionCallback(this);
        AMQPSessionContext protonSession = new AMQPSessionContext(sessionSPI, this, realSession, this.protocolManager.getServer());
        return protonSession;
    }

    public Map<Session, AMQPSessionContext> getSessions() {
        return this.sessions;
    }

    public SecurityAuth getSecurityAuth() {
        return new LocalSecurity();
    }

    public SASLResult getSASLResult() {
        return this.handler.getSASLResult();
    }

    public void inputBuffer(ByteBuf buffer) {
        if (logger.isTraceEnabled()) {
            ByteUtil.debugFrame((Logger)logger, (String)"Buffer Received ", (ByteBuf)buffer);
        }
        this.handler.inputBuffer(buffer);
    }

    public ProtonHandler getHandler() {
        return this.handler;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getValidatedUser() {
        return this.validatedUser;
    }

    public void destroy() {
        this.handler.runLater(() -> this.connectionCallback.close());
    }

    public boolean isSyncOnFlush() {
        return false;
    }

    public void instantFlush() {
        this.handler.instantFlush();
    }

    public void flush() {
        this.handler.flush();
    }

    public void afterFlush(Runnable runnable) {
        this.handler.afterFlush(runnable);
    }

    public void close(ErrorCondition errorCondition) {
        Future scheduledFuture = this.scheduledFutureRef.getAndSet(null);
        if (this.scheduledPool instanceof ThreadPoolExecutor && scheduledFuture != null && scheduledFuture != VOID_FUTURE && scheduledFuture instanceof Runnable && !((ThreadPoolExecutor)((Object)this.scheduledPool)).remove((Runnable)((Object)scheduledFuture)) && !scheduledFuture.isCancelled() && !scheduledFuture.isDone()) {
            ActiveMQAMQPProtocolLogger.LOGGER.cantRemovingScheduledTask();
        }
        this.handler.close(errorCondition, this);
    }

    public AMQPSessionContext getSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AMQPSessionContext sessionExtension = this.sessions.get(realSession);
        if (sessionExtension == null) {
            sessionExtension = this.newSessionExtension(realSession);
            realSession.setContext((Object)sessionExtension);
            this.sessions.put(realSession, sessionExtension);
        }
        return sessionExtension;
    }

    public void runOnPool(Runnable run) {
        this.handler.runOnPool(run);
    }

    public void runNow(Runnable run) {
        this.handler.runNow(run);
    }

    public void runLater(Runnable run) {
        this.handler.runLater(run);
    }

    protected boolean validateConnection(Connection connection) {
        return this.connectionCallback.validateConnection(connection, this.handler.getSASLResult());
    }

    public boolean checkDataReceived() {
        return this.handler.checkDataReceived();
    }

    public long getCreationTime() {
        return this.handler.getCreationTime();
    }

    public String getRemoteContainer() {
        return this.handler.getConnection().getRemoteContainer();
    }

    public String getPubSubPrefix() {
        return null;
    }

    protected void initInternal() throws Exception {
    }

    public AMQPConnectionCallback getConnectionCallback() {
        return this.connectionCallback;
    }

    protected void remoteLinkOpened(Link link) throws Exception {
        AMQPSessionContext protonSession = this.getSessionExtension(link.getSession());
        Runnable runnable = (Runnable)link.attachments().get(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class);
        if (runnable != null) {
            link.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, null);
            runnable.run();
            return;
        }
        if (link.getLocalState() == EndpointState.ACTIVE) {
            return;
        }
        link.setSource(link.getRemoteSource());
        link.setTarget(link.getRemoteTarget());
        if (link instanceof Receiver) {
            Receiver receiver = (Receiver)link;
            if (link.getRemoteTarget() instanceof Coordinator) {
                Coordinator coordinator = (Coordinator)link.getRemoteTarget();
                protonSession.addTransactionHandler(coordinator, receiver);
            } else if (AMQPConnectionContext.isReplicaTarget((Link)receiver)) {
                this.handleReplicaTargetLinkOpened(protonSession, receiver);
            } else if (AMQPConnectionContext.isFederationControlLink(receiver)) {
                this.handleFederationControlLinkOpened(protonSession, receiver);
            } else {
                protonSession.addReceiver(receiver);
            }
        } else {
            Sender sender = (Sender)link;
            if (AMQPConnectionContext.isFederationAddressReceiver(sender)) {
                protonSession.addSender(sender, new AMQPFederationAddressSenderController(protonSession));
            } else if (AMQPConnectionContext.isFederationQueueReceiver(sender)) {
                protonSession.addSender(sender, new AMQPFederationQueueSenderController(protonSession));
            } else {
                protonSession.addSender(sender);
            }
        }
    }

    private void handleReplicaTargetLinkOpened(AMQPSessionContext protonSession, Receiver receiver) throws Exception {
        try {
            try {
                protonSession.getSessionSPI().check(SimpleString.toSimpleString((String)receiver.getTarget().getAddress()), CheckType.SEND, this.getSecurityAuth());
            }
            catch (ActiveMQSecurityException e) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingProducer(e.getMessage());
            }
            if (!AmqpSupport.verifyDesiredCapability((Link)receiver, AMQPMirrorControllerSource.MIRROR_CAPABILITY)) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingDesiredCapability(AMQPMirrorControllerSource.MIRROR_CAPABILITY.toString());
            }
        }
        catch (ActiveMQAMQPException e) {
            logger.warn(e.getMessage(), (Throwable)((Object)e));
            receiver.setTarget(null);
            receiver.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            receiver.close();
            return;
        }
        receiver.setOfferedCapabilities(new Symbol[]{AMQPMirrorControllerSource.MIRROR_CAPABILITY});
        protonSession.addReplicaTarget(receiver);
    }

    private void handleFederationControlLinkOpened(AMQPSessionContext protonSession, Receiver receiver) throws Exception {
        try {
            try {
                protonSession.getSessionSPI().check(SimpleString.toSimpleString((String)"$ACTIVEMQ_ARTEMIS_FEDERATION"), CheckType.SEND, this.getSecurityAuth());
            }
            catch (ActiveMQSecurityException e) {
                throw new ActiveMQAMQPSecurityException("User does not have permission to attach to the federation control address");
            }
            protonSession.addFederationCommandProcessor(receiver);
        }
        catch (ActiveMQAMQPException e) {
            logger.warn(e.getMessage(), (Throwable)((Object)e));
            receiver.setTarget(null);
            receiver.setCondition(new ErrorCondition(e.getAmqpError(), e.getMessage()));
            receiver.close();
            return;
        }
    }

    private static boolean isReplicaTarget(Link link) {
        return link != null && link.getTarget() != null && link.getTarget().getAddress() != null && link.getTarget().getAddress().startsWith("$ACTIVEMQ_ARTEMIS_MIRROR");
    }

    private static boolean isFederationControlLink(Receiver receiver) {
        return AmqpSupport.verifyDesiredCapability((Link)receiver, AMQPFederationConstants.FEDERATION_CONTROL_LINK);
    }

    private static boolean isFederationQueueReceiver(Sender sender) {
        return AmqpSupport.verifyDesiredCapability((Link)sender, AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER);
    }

    private static boolean isFederationAddressReceiver(Sender sender) {
        return AmqpSupport.verifyDesiredCapability((Link)sender, AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER);
    }

    public Symbol[] getConnectionCapabilitiesOffered() {
        URI tc = this.connectionCallback.getFailoverList();
        if (tc != null) {
            HashMap<Symbol, Object> hostDetails = new HashMap<Symbol, Object>();
            hostDetails.put(AmqpSupport.NETWORK_HOST, tc.getHost());
            boolean isSSL = tc.getQuery().contains("sslEnabled=true");
            if (isSSL) {
                hostDetails.put(AmqpSupport.SCHEME, "amqps");
            } else {
                hostDetails.put(AmqpSupport.SCHEME, "amqp");
            }
            hostDetails.put(AmqpSupport.HOSTNAME, tc.getHost());
            hostDetails.put(AmqpSupport.PORT, tc.getPort());
            this.connectionProperties.put(AmqpSupport.FAILOVER_SERVER_LIST, Arrays.asList(hostDetails));
        }
        return ExtCapability.getCapabilities();
    }

    public void open() {
        this.handler.open(this.containerId, this.connectionProperties);
    }

    public String getContainer() {
        return this.containerId;
    }

    public void addEventHandler(EventHandler eventHandler) {
        this.handler.addEventHandler(eventHandler);
    }

    public ProtonProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public int getAmqpLowCredits() {
        if (this.protocolManager != null) {
            return this.protocolManager.getAmqpLowCredits();
        }
        return 300;
    }

    public int getAmqpCredits() {
        if (this.protocolManager != null) {
            return this.protocolManager.getAmqpCredits();
        }
        return 1000;
    }

    public boolean isUseCoreSubscriptionNaming() {
        return this.useCoreSubscriptionNaming;
    }

    @Override
    public void onAuthInit(ProtonHandler handler, Connection connection, boolean sasl) {
        if (sasl) {
            String[] mechanisms = this.connectionCallback.getSaslMechanisms();
            if (mechanisms == null || mechanisms.length == 0) {
                mechanisms = AnonymousServerSASL.ANONYMOUS_MECH;
            }
            handler.createServerSASL(mechanisms);
        } else if (!this.connectionCallback.isSupportsAnonymous()) {
            this.connectionCallback.sendSASLSupported();
            this.connectionCallback.close();
            handler.close(null, this);
        }
    }

    @Override
    public void onSaslRemoteMechanismChosen(ProtonHandler handler, String mech) {
        handler.setChosenMechanism(this.connectionCallback.getServerSASL(mech));
    }

    @Override
    public void onSaslMechanismsOffered(ProtonHandler handler, String[] mechanisms) {
        if (this.saslClientFactory != null) {
            handler.setClientMechanism(this.saslClientFactory.chooseMechanism(mechanisms));
        }
    }

    @Override
    public void onAuthFailed(ProtonHandler protonHandler, Connection connection) {
        this.connectionCallback.close();
        this.handler.close(null, this);
    }

    @Override
    public void onAuthSuccess(ProtonHandler protonHandler, Connection connection) {
        connection.open();
    }

    @Override
    public void onTransport(Transport transport) {
        this.handler.flushBytes();
    }

    @Override
    public void pushBytes(ByteBuf bytes) {
        this.connectionCallback.onTransport(bytes, this);
    }

    @Override
    public boolean flowControl(ReadyListener readyListener) {
        return this.connectionCallback.isWritable(readyListener);
    }

    @Override
    public String getRemoteAddress() {
        return this.connectionCallback.getTransportConnection().getRemoteAddress();
    }

    @Override
    public void onRemoteOpen(Connection connection) throws Exception {
        long nextKeepAliveTime;
        this.handler.requireHandler();
        try {
            this.initInternal();
        }
        catch (Exception e) {
            logger.error("Error init connection", (Throwable)e);
        }
        if (!this.validateUser(connection) || this.connectionCallback.getTransportConnection().getRouter() != null && this.protocolManager.getRoutingHandler().route(this, connection) || !this.validateConnection(connection)) {
            connection.close();
        } else {
            connection.setContext((Object)this);
            connection.setContainer(this.containerId);
            connection.setProperties(this.connectionProperties);
            connection.setOfferedCapabilities(this.getConnectionCapabilitiesOffered());
            connection.open();
        }
        this.initialize();
        if (!(connection.getRemoteProperties() != null && connection.getRemoteProperties().containsKey(CONNECTION_OPEN_FAILED) || (nextKeepAliveTime = this.handler.tick(true).longValue()) == 0L || this.scheduledPool == null)) {
            this.scheduleOp.setDelay(nextKeepAliveTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
            this.scheduledFutureRef.getAndUpdate(this.scheduleOp);
        }
    }

    private boolean validateUser(Connection connection) throws Exception {
        this.user = null;
        this.password = null;
        this.validatedUser = null;
        SASLResult saslResult = this.getSASLResult();
        if (saslResult != null) {
            this.user = saslResult.getUser();
            if (saslResult instanceof PlainSASLResult) {
                this.password = ((PlainSASLResult)saslResult).getPassword();
            }
        }
        if (this.isIncomingConnection() && this.saslClientFactory == null && !this.isBridgeConnection()) {
            try {
                this.validatedUser = this.protocolManager.getServer().validateUser(this.user, this.password, (RemotingConnection)this.connectionCallback.getProtonConnectionDelegate(), this.protocolManager.getSecurityDomain());
            }
            catch (ActiveMQSecurityException e) {
                ErrorCondition error = new ErrorCondition();
                error.setCondition(AmqpError.UNAUTHORIZED_ACCESS);
                error.setDescription(e.getMessage() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getMessage());
                connection.setCondition(error);
                connection.setProperties(Collections.singletonMap(AmqpSupport.CONNECTION_OPEN_FAILED, true));
                return false;
            }
        }
        return true;
    }

    @Override
    public void onRemoteClose(Connection connection) {
        this.handler.requireHandler();
        connection.close();
        connection.free();
        for (AMQPSessionContext protonSession : this.sessions.values()) {
            protonSession.close();
        }
        this.sessions.clear();
        this.handler.flushBytes();
        this.destroy();
    }

    @Override
    public void onLocalOpen(Session session) throws Exception {
        AMQPSessionContext sessionContext = this.getSessionExtension(session);
        if (this.bridgeConnection) {
            sessionContext.initialize();
        }
    }

    @Override
    public void onRemoteOpen(Session session) throws Exception {
        if (session.getConnection().getLocalState() != EndpointState.CLOSED) {
            this.handler.requireHandler();
            this.getSessionExtension(session).initialize();
            session.open();
        }
    }

    @Override
    public void onRemoteClose(Session session) throws Exception {
        this.handler.runLater(() -> {
            session.close();
            session.free();
            AMQPSessionContext sessionContext = (AMQPSessionContext)session.getContext();
            if (sessionContext != null) {
                sessionContext.close();
                this.sessions.remove(session);
                session.setContext(null);
            }
        });
    }

    @Override
    public void onRemoteOpen(Link link) throws Exception {
        if (link.getSession().getConnection().getLocalState() != EndpointState.CLOSED) {
            this.remoteLinkOpened(link);
        }
    }

    @Override
    public void onFlow(Link link) throws Exception {
        if (link.getContext() != null) {
            ((ProtonDeliveryHandler)link.getContext()).onFlow(link.getCredit(), link.getDrain());
        }
    }

    @Override
    public void onRemoteClose(Link link) throws Exception {
        this.handler.requireHandler();
        AtomicReference handlerThrew = new AtomicReference();
        this.linkCloseListeners.forEach((k, v) -> {
            try {
                v.onClose(link);
            }
            catch (Exception e) {
                handlerThrew.compareAndSet(null, e);
            }
        });
        ProtonDeliveryHandler linkContext = (ProtonDeliveryHandler)link.getContext();
        if (linkContext != null) {
            try {
                linkContext.close(true);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        link.close();
        link.free();
        this.flush();
        if (handlerThrew.get() != null) {
            throw (Exception)handlerThrew.get();
        }
    }

    @Override
    public void onRemoteDetach(Link link) throws Exception {
        boolean handleAsClose;
        this.handler.requireHandler();
        boolean bl = handleAsClose = link.getSource() != null && ((Source)link.getSource()).getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH;
        if (handleAsClose) {
            this.onRemoteClose(link);
        } else {
            link.detach();
            link.free();
        }
    }

    @Override
    public void onLocalDetach(Link link) throws Exception {
        this.handler.requireHandler();
        Object context = link.getContext();
        if (context instanceof ProtonServerSenderContext) {
            ProtonServerSenderContext senderContext = (ProtonServerSenderContext)context;
            senderContext.close(false);
        }
    }

    @Override
    public void onDelivery(Delivery delivery) throws Exception {
        this.handler.requireHandler();
        ProtonDeliveryHandler handler = (ProtonDeliveryHandler)delivery.getLink().getContext();
        if (handler != null) {
            handler.onMessage(delivery);
        } else {
            logger.warn("Handler is null, can't delivery {}", (Object)delivery, (Object)new Exception("tracing location"));
        }
    }

    private class LocalSecurity
    implements SecurityAuth {
        private LocalSecurity() {
        }

        public String getUsername() {
            String username = null;
            SASLResult saslResult = AMQPConnectionContext.this.getSASLResult();
            if (saslResult != null) {
                username = saslResult.getUser();
            }
            return username;
        }

        public String getPassword() {
            String password = null;
            SASLResult saslResult = AMQPConnectionContext.this.getSASLResult();
            if (saslResult != null && saslResult instanceof PlainSASLResult) {
                password = ((PlainSASLResult)saslResult).getPassword();
            }
            return password;
        }

        public RemotingConnection getRemotingConnection() {
            return AMQPConnectionContext.this.connectionCallback.getProtonConnectionDelegate();
        }

        public String getSecurityDomain() {
            return AMQPConnectionContext.this.getProtocolManager().getSecurityDomain();
        }
    }

    class ScheduleRunnable
    implements Runnable {
        final TickerRunnable tickerRunnable;

        ScheduleRunnable() {
            this.tickerRunnable = new TickerRunnable();
        }

        @Override
        public void run() {
            AMQPConnectionContext.this.handler.runLater(this.tickerRunnable);
        }
    }

    class TickerRunnable
    implements Runnable {
        TickerRunnable() {
        }

        @Override
        public void run() {
            Long rescheduleAt = AMQPConnectionContext.this.handler.tick(false);
            if (rescheduleAt == null) {
                AMQPConnectionContext.this.scheduleOp.setDelay(10L);
                AMQPConnectionContext.this.scheduledFutureRef.getAndUpdate(AMQPConnectionContext.this.scheduleOp);
            } else if (rescheduleAt != 0L) {
                AMQPConnectionContext.this.scheduleOp.setDelay(rescheduleAt - TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
                AMQPConnectionContext.this.scheduledFutureRef.getAndUpdate(AMQPConnectionContext.this.scheduleOp);
            }
        }
    }

    class ScheduleOperator
    implements UnaryOperator<Future<?>> {
        private long delay;
        final ScheduleRunnable scheduleRunnable;

        ScheduleOperator(ScheduleRunnable scheduleRunnable) {
            this.scheduleRunnable = scheduleRunnable;
        }

        @Override
        public Future<?> apply(Future<?> future) {
            return future != null ? AMQPConnectionContext.this.scheduledPool.schedule(this.scheduleRunnable, this.delay, TimeUnit.MILLISECONDS) : null;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }
    }
}

