/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.SimpleDatabaseVersion;

public interface DatabaseVersion {
    public static final int NO_VERSION = -9999;

    public static DatabaseVersion make(Integer major) {
        return DatabaseVersion.make(major, 0);
    }

    public static DatabaseVersion make(Integer major, Integer minor) {
        return DatabaseVersion.make(major, minor, 0);
    }

    public static DatabaseVersion make(Integer major, Integer minor, Integer micro) {
        return new SimpleDatabaseVersion(major, minor, micro);
    }

    public int getDatabaseMajorVersion();

    public int getDatabaseMinorVersion();

    default public int getDatabaseMicroVersion() {
        return 0;
    }

    default public int getMajor() {
        return this.getDatabaseMajorVersion();
    }

    default public int getMinor() {
        return this.getDatabaseMinorVersion();
    }

    default public int getMicro() {
        return this.getDatabaseMicroVersion();
    }

    default public DatabaseVersion makeCopy() {
        return new SimpleDatabaseVersion(this);
    }

    default public DatabaseVersion makeCopy(boolean noVersionAsZero) {
        return new SimpleDatabaseVersion(this, noVersionAsZero);
    }

    default public boolean isSame(DatabaseVersion other) {
        return this.isSame(other.getDatabaseMajorVersion(), other.getDatabaseMinorVersion(), other.getDatabaseMicroVersion());
    }

    default public boolean isSame(int otherMajor) {
        return this.getDatabaseMajorVersion() == otherMajor;
    }

    default public boolean isSame(int otherMajor, int otherMinor) {
        return this.isSame(otherMajor) && this.getDatabaseMinorVersion() == otherMinor;
    }

    default public boolean isSame(int otherMajor, int otherMinor, int otherMicro) {
        return this.isSame(otherMajor, otherMinor) && this.getDatabaseMicroVersion() == otherMicro;
    }

    default public boolean isSameOrAfter(DatabaseVersion other) {
        return this.isSameOrAfter(other.getDatabaseMajorVersion(), other.getDatabaseMinorVersion());
    }

    default public boolean isSameOrAfter(Integer otherMajor, Integer otherMinor) {
        return this.isSameOrAfter((int)otherMajor, otherMinor == null ? -9999 : otherMinor);
    }

    default public boolean isSameOrAfter(int otherMajor) {
        int major = this.getDatabaseMajorVersion();
        return major >= otherMajor;
    }

    default public boolean isSameOrAfter(int otherMajor, int otherMinor) {
        int major = this.getDatabaseMajorVersion();
        int minor = this.getDatabaseMinorVersion();
        return major > otherMajor || major == otherMajor && minor >= otherMinor;
    }

    default public boolean isSameOrAfter(int otherMajor, int otherMinor, int otherMicro) {
        int major = this.getDatabaseMajorVersion();
        int minor = this.getDatabaseMinorVersion();
        int micro = this.getDatabaseMicroVersion();
        return major > otherMajor || major == otherMajor && minor > otherMinor || major == otherMajor && minor == otherMinor && micro >= otherMicro;
    }

    default public boolean isAfter(DatabaseVersion other) {
        return this.isAfter(other.getDatabaseMajorVersion(), other.getDatabaseMinorVersion());
    }

    default public boolean isAfter(Integer major, Integer minor) {
        return this.isAfter((int)major, minor == null ? -9999 : minor);
    }

    default public boolean isAfter(int major) {
        return this.getDatabaseMajorVersion() > major;
    }

    default public boolean isAfter(int major, int minor) {
        return this.getDatabaseMajorVersion() > major || this.getDatabaseMajorVersion() == major && this.getDatabaseMinorVersion() > minor;
    }

    default public boolean isAfter(int otherMajor, int otherMinor, int otherMicro) {
        int major = this.getDatabaseMajorVersion();
        int minor = this.getDatabaseMinorVersion();
        int micro = this.getDatabaseMicroVersion();
        return major > otherMajor || major == otherMajor && minor > otherMinor || major == otherMajor && minor == otherMinor && otherMicro > micro;
    }

    default public boolean isBefore(DatabaseVersion other) {
        return this.isBefore(other.getDatabaseMajorVersion(), other.getDatabaseMinorVersion());
    }

    default public boolean isBefore(int major, int minor) {
        return !this.isSameOrAfter(major, minor);
    }

    default public boolean isBefore(int major) {
        return !this.isSameOrAfter(major);
    }

    default public boolean isBefore(Integer major, Integer minor) {
        return this.isBefore((int)major, minor == null ? -9999 : minor);
    }

    default public boolean isBefore(int otherMajor, int otherMinor, int otherMicro) {
        return !this.isSameOrAfter(otherMajor, otherMinor, otherMicro);
    }
}

