/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.temptable;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.function.Function;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableExporter;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractWork;

public class TemporaryTableHelper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(TemporaryTableHelper.class);
    public static final String SESSION_ID_COLUMN_NAME = "hib_sess_id";
    private static SqlExceptionHelper.WarningHandler WARNING_HANDLER = new SqlExceptionHelper.WarningHandlerLoggingSupport(){

        @Override
        public boolean doProcess() {
            return log.isDebugEnabled();
        }

        @Override
        public void prepare(SQLWarning warning) {
            log.warningsCreatingTempTable(warning);
        }

        @Override
        protected void logWarning(String description, String message) {
            log.debug(description);
            log.debug(message);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cleanTemporaryTableRows(TemporaryTable temporaryTable, TemporaryTableExporter exporter, Function<SharedSessionContractImplementor, String> sessionUidAccess, SharedSessionContractImplementor session) {
        PreparedStatement ps = null;
        String sql23333332 = exporter.getSqlTruncateCommand(temporaryTable, sessionUidAccess, session);
        ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql23333332, false);
        if (temporaryTable.getSessionUidColumn() != null) {
            String sessionUid = sessionUidAccess.apply(session);
            ps.setString(1, sessionUid);
        }
        session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps, sql23333332);
        if (ps == null) return;
        try {
            session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
            return;
        }
        catch (Throwable sql23333332) {}
        return;
        catch (Throwable t) {
            try {
                log.unableToCleanupTemporaryIdTable(t);
                if (ps == null) return;
            }
            catch (Throwable throwable) {
                if (ps == null) throw throwable;
                try {
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(ps);
                return;
            }
            catch (Throwable throwable) {}
            return;
        }
    }

    private static void logStatement(String sql, JdbcServices jdbcServices) {
        SqlStatementLogger statementLogger = jdbcServices.getSqlStatementLogger();
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
    }

    public static class TemporaryTableDropWork
    extends AbstractWork {
        private final TemporaryTable temporaryTable;
        private final TemporaryTableExporter exporter;
        private final SessionFactoryImplementor sessionFactory;

        public TemporaryTableDropWork(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
            this(temporaryTable, sessionFactory.getJdbcServices().getDialect().getTemporaryTableExporter(), sessionFactory);
        }

        public TemporaryTableDropWork(TemporaryTable temporaryTable, TemporaryTableExporter exporter, SessionFactoryImplementor sessionFactory) {
            this.temporaryTable = temporaryTable;
            this.exporter = exporter;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public void execute(Connection connection) {
            JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
            try {
                String dropCommand = this.exporter.getSqlDropCommand(this.temporaryTable);
                TemporaryTableHelper.logStatement(dropCommand, jdbcServices);
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(dropCommand);
                    jdbcServices.getSqlExceptionHelper().handleAndClearWarnings(statement, WARNING_HANDLER);
                }
                catch (SQLException e) {
                    log.debugf("unable to drop temporary table [%s]; `%s` failed : %s", this.temporaryTable.getQualifiedTableName(), dropCommand, e.getMessage());
                }
            }
            catch (Exception e) {
                log.debugf("Error dropping temporary table(s) : %s", e.getMessage());
            }
        }
    }

    public static class TemporaryTableCreationWork
    extends AbstractWork {
        private final TemporaryTable temporaryTable;
        private final TemporaryTableExporter exporter;
        private final SessionFactoryImplementor sessionFactory;

        public TemporaryTableCreationWork(TemporaryTable temporaryTable, SessionFactoryImplementor sessionFactory) {
            this(temporaryTable, sessionFactory.getJdbcServices().getDialect().getTemporaryTableExporter(), sessionFactory);
        }

        public TemporaryTableCreationWork(TemporaryTable temporaryTable, TemporaryTableExporter exporter, SessionFactoryImplementor sessionFactory) {
            this.temporaryTable = temporaryTable;
            this.exporter = exporter;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public void execute(Connection connection) {
            JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
            try {
                String creationCommand = this.exporter.getSqlCreateCommand(this.temporaryTable);
                TemporaryTableHelper.logStatement(creationCommand, jdbcServices);
                try (Statement statement = connection.createStatement();){
                    statement.executeUpdate(creationCommand);
                    jdbcServices.getSqlExceptionHelper().handleAndClearWarnings(statement, WARNING_HANDLER);
                }
                catch (SQLException e) {
                    log.debugf("unable to create temporary table [%s]; `%s` failed : %s", this.temporaryTable.getQualifiedTableName(), creationCommand, e.getMessage());
                }
            }
            catch (Exception e) {
                log.debugf("Error creating temporary table(s) : %s", e.getMessage());
            }
        }
    }
}

