/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.cte;

import jakarta.persistence.metamodel.Bindable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaCteCriteriaType;
import org.hibernate.query.derived.AnonymousTupleSimpleSqmPathSource;
import org.hibernate.query.derived.AnonymousTupleType;
import org.hibernate.query.derived.CteTupleTableGroupProducer;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.type.BasicType;

public class SqmCteTable<T>
extends AnonymousTupleType<T>
implements JpaCteCriteriaType<T> {
    private final String name;
    private final SqmCteStatement<T> cteStatement;
    private final List<SqmCteTableColumn> columns;

    private SqmCteTable(String name, SqmCteStatement<T> cteStatement, SqmSelectableNode<?>[] sqmSelectableNodes) {
        super(sqmSelectableNodes);
        this.name = name;
        this.cteStatement = cteStatement;
        ArrayList<SqmCteTableColumn> columns = new ArrayList<SqmCteTableColumn>(this.componentCount());
        for (int i = 0; i < this.componentCount(); ++i) {
            columns.add(new SqmCteTableColumn(this, this.getComponentName(i), this.get(i)));
        }
        this.columns = columns;
    }

    public static <X> SqmCteTable<X> createStatementTable(String name, SqmCteStatement<X> cteStatement, SqmSelectQuery<X> selectStatement) {
        SqmSelectableNode[] sqmSelectableNodes = (SqmSelectableNode[])((SqmQuerySpec)selectStatement.getQuerySpec()).getSelectClause().getSelectionItems().toArray(SqmSelectableNode[]::new);
        return new SqmCteTable<X>(name, cteStatement, sqmSelectableNodes);
    }

    @Override
    public CteTupleTableGroupProducer resolveTableGroupProducer(String aliasStem, List<SqlSelection> sqlSelections, FromClauseAccess fromClauseAccess) {
        return new CteTupleTableGroupProducer(this, aliasStem, sqlSelections, fromClauseAccess);
    }

    public String getCteName() {
        return this.name;
    }

    public AnonymousTupleType<?> getTupleType() {
        return this;
    }

    public List<SqmCteTableColumn> getColumns() {
        return this.columns;
    }

    public SqmCteStatement<T> getCteStatement() {
        return this.cteStatement;
    }

    @Override
    public String getName() {
        if (Character.isDigit(this.name.charAt(0))) {
            return null;
        }
        return this.name;
    }

    @Override
    public DomainType<T> getType() {
        return this;
    }

    @Override
    public List<JpaCteCriteriaAttribute> getAttributes() {
        return this.columns;
    }

    @Override
    public JpaCteCriteriaAttribute getAttribute(String name) {
        Integer index = this.getIndex(name);
        if (index == null) {
            return null;
        }
        return this.columns.get(index);
    }

    @Override
    public SqmExpressible<?> get(String componentName) {
        SqmExpressible<?> sqmExpressible = super.get(componentName);
        if (sqmExpressible != null) {
            return sqmExpressible;
        }
        return this.determineRecursiveCteAttributeType(this.name);
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        SqmPathSource<?> subPathSource = super.findSubPathSource(name);
        if (subPathSource != null) {
            return subPathSource;
        }
        BasicType<?> type = this.determineRecursiveCteAttributeType(name);
        if (type == null) {
            return null;
        }
        return new AnonymousTupleSimpleSqmPathSource(name, type, Bindable.BindableType.SINGULAR_ATTRIBUTE);
    }

    private BasicType<?> determineRecursiveCteAttributeType(String name) {
        if (name.equals(this.cteStatement.getSearchAttributeName())) {
            return this.cteStatement.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(String.class);
        }
        if (name.equals(this.cteStatement.getCyclePathAttributeName())) {
            return this.cteStatement.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(String.class);
        }
        if (name.equals(this.cteStatement.getCycleMarkAttributeName())) {
            return (BasicType)this.cteStatement.getCycleLiteral().getNodeType();
        }
        return null;
    }
}

