/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.registry;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.metrics.MetricMetadata;
import org.wildfly.extension.micrometer.metrics.WildFlyMetric;

public interface WildFlyRegistry {
    public Meter remove(Meter.Id var1);

    default public Meter.Id addMeter(WildFlyMetric metric, MetricMetadata metadata) {
        switch (metadata.getType()) {
            case GAUGE: {
                return this.addGauge(metric, metadata);
            }
            case COUNTER: {
                return this.addCounter(metric, metadata);
            }
        }
        throw MicrometerExtensionLogger.MICROMETER_LOGGER.unsupportedMetricType(metadata.getType().name());
    }

    default public void close() {
    }

    private Meter.Id addCounter(WildFlyMetric metric, MetricMetadata metadata) {
        return FunctionCounter.builder((String)metadata.getMetricName(), (Object)metric, value -> this.getMetricValue(metric, metadata.getMeasurementUnit())).tags((Iterable)this.getTags(metadata)).baseUnit(this.getBaseUnit(metadata)).description(metadata.getDescription()).register((MeterRegistry)this).getId();
    }

    private Meter.Id addGauge(WildFlyMetric metric, MetricMetadata metadata) {
        return Gauge.builder((String)metadata.getMetricName(), (Object)metric, value -> this.getMetricValue(metric, metadata.getMeasurementUnit())).tags((Iterable)this.getTags(metadata)).baseUnit(this.getBaseUnit(metadata)).description(metadata.getDescription()).register((MeterRegistry)this).getId();
    }

    private Tags getTags(MetricMetadata metadata) {
        return Tags.of((Iterable)Arrays.stream(metadata.getTags()).map(t -> Tag.of((String)t.getKey(), (String)t.getValue())).collect(Collectors.toList()));
    }

    private String getBaseUnit(MetricMetadata metadata) {
        String measurementUnit = metadata.getBaseMetricUnit();
        return "none".equalsIgnoreCase(measurementUnit) ? null : measurementUnit.toLowerCase();
    }

    private double getMetricValue(WildFlyMetric metric, MeasurementUnit unit) {
        OptionalDouble metricValue = metric.getValue();
        return metricValue.isPresent() ? this.scaleToBaseUnit(metricValue.getAsDouble(), unit) : 0.0;
    }

    private double scaleToBaseUnit(double value, MeasurementUnit unit) {
        return value * MeasurementUnit.calculateOffset((MeasurementUnit)unit, (MeasurementUnit)unit.getBaseUnits());
    }
}

