/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.Util;

public class UDP
extends TP {
    @Property(description="Traffic class for sending unicast and multicast datagrams")
    protected int tos;
    protected static final String UCAST_NAME = "ucast-receiver";
    protected static final String MCAST_NAME = "mcast-receiver";
    @Property(name="mcast_addr", description="The multicast address used for sending and receiving packets", defaultValueIPv4="239.8.8.8", defaultValueIPv6="ff0e::8:8:8", systemProperty={"jgroups.udp.mcast_addr"}, writable=false)
    protected InetAddress mcast_group_addr;
    @Property(description="The multicast port used for sending and receiving packets. Default is 7600", systemProperty={"jgroups.udp.mcast_port"}, writable=false)
    protected int mcast_port = 7600;
    @Property(description="Multicast toggle. If false multiple unicast datagrams are sent instead of one multicast. Default is true", writable=false)
    protected boolean ip_mcast = true;
    @Property(description="The time-to-live (TTL) for multicast datagram packets. Default is 8", systemProperty={"jgroups.udp.ip_ttl"})
    protected int ip_ttl = 8;
    @Property(description="Send buffer size of the multicast datagram socket", type=AttributeType.BYTES)
    protected int mcast_send_buf_size = 65541;
    @Property(description="Receive buffer size of the multicast datagram socket", type=AttributeType.BYTES)
    protected int mcast_recv_buf_size = 5000000;
    @Property(description="Send buffer size of the unicast datagram socket", type=AttributeType.BYTES)
    protected int ucast_send_buf_size = 200000;
    @Property(description="Receive buffer size of the unicast datagram socket", type=AttributeType.BYTES)
    protected int ucast_recv_buf_size = 5000000;
    @Property(description="If true, disables IP_MULTICAST_LOOP on the MulticastSocket (for sending and receiving of multicast packets). IP multicast packets send on a host P will therefore not be received by anyone on P. Use with caution.")
    protected boolean disable_loopback = false;
    @Property(description="Suppresses warnings on Mac OS (for now) about not enough buffer space when sending a datagram packet", type=AttributeType.TIME)
    protected long suppress_time_out_of_buffer_space = 60000L;
    protected int unicast_receiver_threads = 1;
    protected int multicast_receiver_threads = 1;
    protected IpAddress mcast_addr;
    protected MulticastSocket sock;
    protected MulticastSocket mcast_sock;
    protected PacketReceiver[] mcast_receivers;
    protected PacketReceiver[] ucast_receivers;
    protected SuppressLog<InetAddress> suppress_log_out_of_buffer_space;
    protected static final boolean is_android = Util.checkForAndroid();
    protected static final boolean is_mac = Util.checkForMac();

    @Override
    public boolean supportsMulticasting() {
        return this.ip_mcast;
    }

    public <T extends UDP> T setMulticasting(boolean fl) {
        this.ip_mcast = fl;
        return (T)this;
    }

    public <T extends UDP> T setMulticastAddress(InetAddress a) {
        this.mcast_group_addr = a;
        return (T)this;
    }

    public InetAddress getMulticastAddress() {
        return this.mcast_group_addr;
    }

    public int getMulticastPort() {
        return this.mcast_port;
    }

    public <T extends UDP> T setMulticastPort(int mcast_port) {
        this.mcast_port = mcast_port;
        return (T)this;
    }

    public int getTos() {
        return this.tos;
    }

    public UDP setTos(int t) {
        this.tos = t;
        return this;
    }

    public InetAddress getMcastGroupAddr() {
        return this.mcast_group_addr;
    }

    public UDP setMcastGroupAddr(InetAddress m) {
        this.mcast_group_addr = m;
        return this;
    }

    public boolean ipMcast() {
        return this.ip_mcast;
    }

    public UDP ipMcast(boolean i) {
        this.ip_mcast = i;
        return this;
    }

    public int getIpTTL() {
        return this.ip_ttl;
    }

    public UDP setIpTTL(int i) {
        this.ip_ttl = i;
        return this;
    }

    public int getMcastSendBufSize() {
        return this.mcast_send_buf_size;
    }

    public UDP setMcastSendBufSize(int m) {
        this.mcast_send_buf_size = m;
        return this;
    }

    public int getMcastRecvBufSize() {
        return this.mcast_recv_buf_size;
    }

    public UDP setMcastRecvBufSize(int m) {
        this.mcast_recv_buf_size = m;
        return this;
    }

    public int getUcastSendBufSize() {
        return this.ucast_send_buf_size;
    }

    public UDP setUcastSendBufSize(int u) {
        this.ucast_send_buf_size = u;
        return this;
    }

    public int getUcastRecvBufSize() {
        return this.ucast_recv_buf_size;
    }

    public UDP setUcastRecvBufSize(int u) {
        this.ucast_recv_buf_size = u;
        return this;
    }

    public boolean disableLoopback() {
        return this.disable_loopback;
    }

    public UDP disableLoopback(boolean d) {
        this.disable_loopback = d;
        return this;
    }

    public long getSuppressTimeOutOfBufferSpace() {
        return this.suppress_time_out_of_buffer_space;
    }

    public UDP setSuppressTimeOutOfBufferSpace(long s) {
        this.suppress_time_out_of_buffer_space = s;
        return this;
    }

    public <T extends UDP> T setMulticastTTL(int ttl) {
        this.ip_ttl = ttl;
        this.setTimeToLive(ttl, this.sock);
        return (T)this;
    }

    public int getMulticastTTL() {
        return this.ip_ttl;
    }

    @ManagedAttribute(description="Number of messages dropped when sending because of insufficient buffer space", type=AttributeType.SCALAR)
    public int getDroppedMessages() {
        return this.suppress_log_out_of_buffer_space != null ? this.suppress_log_out_of_buffer_space.getCache().size() : 0;
    }

    @ManagedOperation(description="Clears the cache for dropped messages")
    public <T extends UDP> T clearDroppedMessagesCache() {
        if (this.suppress_log_out_of_buffer_space != null) {
            this.suppress_log_out_of_buffer_space.getCache().clear();
        }
        return (T)this;
    }

    @Property(description="Number of unicast receiver threads, all reading from the same DatagramSocket. If de-serialization is slow, increasing the number of receiver threads might yield better performance.")
    public <T extends UDP> T setUcastReceiverThreads(int num) {
        if (this.unicast_receiver_threads != num) {
            this.unicast_receiver_threads = num;
            if (this.ucast_receivers != null) {
                this.stopUcastReceiverThreads();
                this.ucast_receivers = this.createReceivers(this.unicast_receiver_threads, this.sock, UCAST_NAME);
                this.startUcastReceiverThreads();
            }
        }
        return (T)this;
    }

    @Property(description="Number of unicast receiver threads, all reading from the same DatagramSocket. If de-serialization is slow, increasing the number of receiver threads might yield better performance.")
    public int getUcastReceiverThreads() {
        return this.unicast_receiver_threads;
    }

    @Property(description="Number of multicast receiver threads, all reading from the same MulticastSocket. If de-serialization is slow, increasing the number of receiver threads might yield better performance.")
    public <T extends UDP> T setMcastReceiverThreads(int num) {
        if (this.multicast_receiver_threads != num) {
            this.multicast_receiver_threads = num;
            if (this.mcast_receivers != null) {
                this.stopMcastReceiverThreads();
                this.mcast_receivers = this.createReceivers(this.multicast_receiver_threads, this.mcast_sock, MCAST_NAME);
                this.startMcastReceiverThreads();
            }
        }
        return (T)this;
    }

    @Property(description="Number of multicast receiver threads, all reading from the same MulticastSocket. If de-serialization is slow, increasing the number of receiver threads might yield better performance.")
    public int getMcastReceiverThreads() {
        return this.multicast_receiver_threads;
    }

    @Override
    public String getInfo() {
        return String.format("group_addr=%s:%d\n", this.mcast_group_addr.getHostName(), this.mcast_port);
    }

    @Override
    public void sendToAll(byte[] data, int offset, int length) throws Exception {
        if (this.ip_mcast && this.mcast_addr != null) {
            if (this.local_transport != null) {
                try {
                    this.local_transport.sendToAll(data, offset, length);
                }
                catch (Exception ex) {
                    this.log.warn("failed sending group message via local transport, sending it via regular transport", ex);
                }
            }
            this._send(this.mcast_addr.getIpAddress(), this.mcast_addr.getPort(), data, offset, length);
        } else {
            super.sendToAll(data, offset, length);
        }
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this._send(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort(), data, offset, length);
    }

    protected void _send(InetAddress dest, int port, byte[] data, int offset, int length) throws Exception {
        DatagramPacket packet = new DatagramPacket(data, offset, length, dest, port);
        if (this.sock != null) {
            try {
                this.sock.send(packet);
            }
            catch (IOException ex) {
                if (this.suppress_log_out_of_buffer_space != null) {
                    this.suppress_log_out_of_buffer_space.log(SuppressLog.Level.warn, dest, this.suppress_time_out_of_buffer_space, this.local_addr, dest == null ? "cluster" : dest, ex);
                }
                throw ex;
            }
        }
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        if (evt.getType() == 6) {
            if (this.suppress_log_out_of_buffer_space != null) {
                this.suppress_log_out_of_buffer_space.removeExpired(this.suppress_time_out_of_buffer_space);
            }
            if (this.local_transport != null) {
                try {
                    this.sock.setLoopbackMode(true);
                    this.mcast_sock.setLoopbackMode(true);
                }
                catch (SocketException e) {
                    this.log.error("failed enabling loopback-mode to", e);
                }
            }
        }
        return retval;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.bundler.getMaxSize() > 65536) {
            throw new IllegalArgumentException("bundler.max_size (" + this.bundler.getMaxSize() + ") cannot exceed the max datagram packet size of 65536");
        }
        if (is_mac && this.suppress_time_out_of_buffer_space > 0L) {
            this.suppress_log_out_of_buffer_space = new SuppressLog(this.log, "FailureSendingToPhysAddr", "SuppressMsg");
        }
    }

    @Override
    public void start() throws Exception {
        try {
            this.createSockets();
            super.start();
        }
        catch (Exception ex) {
            this.destroySockets();
            throw ex;
        }
        this.ucast_receivers = this.createReceivers(this.unicast_receiver_threads, this.sock, UCAST_NAME);
        if (this.ip_mcast) {
            this.mcast_receivers = this.createReceivers(this.multicast_receiver_threads, this.mcast_sock, MCAST_NAME);
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.log.debug("%s: closing sockets and stopping threads", this.local_addr);
        this.destroySockets();
        this.stopThreads();
    }

    @Override
    protected void handleConnect() throws Exception {
        this.startThreads();
    }

    protected void setCorrectSocketBufferSize(MulticastSocket s, int buf_size, int new_size, boolean send, boolean mcast2) throws SocketException {
        String so = String.format("%s%s", mcast2 ? "mcast " : "", send ? "send" : "receive");
        this.log.warn("%s: setting %s socket buffer size (%s) to %s (size of the max datagram packet)", this.local_addr, so, Util.printBytes(buf_size), Util.printBytes(new_size));
        if (send) {
            s.setSendBufferSize(new_size);
        } else {
            s.setReceiveBufferSize(new_size);
        }
    }

    protected static Method findMethod(Class<?> clazz, String method_name, Class<?> ... parameters) {
        try {
            Method method = clazz.getDeclaredMethod(method_name, parameters);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected void createSockets() throws Exception {
        if (this.bind_addr == null) {
            throw new IllegalArgumentException("bind_addr cannot be null");
        }
        Util.checkIfValidAddress(this.bind_addr, this.getName());
        if (this.log.isDebugEnabled()) {
            this.log.debug("sockets will use interface " + this.bind_addr.getHostAddress());
        }
        this.sock = this.bind_port > 0 ? this.createMulticastSocketWithBindPort() : this.createMulticastSocket("jgroups.udp.sock", 0);
        this.setTimeToLive(this.ip_ttl, this.sock);
        if (this.tos > 0) {
            try {
                this.sock.setTrafficClass(this.tos);
            }
            catch (SocketException e) {
                this.log.warn(Util.getMessage("TrafficClass"), this.tos, e);
            }
        }
        if (this.ip_mcast) {
            this.mcast_sock = Util.can_bind_to_mcast_addr ? Util.createMulticastSocket(this.getSocketFactory(), "jgroups.udp.mcast_sock", this.mcast_group_addr, this.mcast_port, this.log) : this.getSocketFactory().createMulticastSocket("jgroups.udp.mcast_sock", this.mcast_port);
            if (this.disable_loopback) {
                this.mcast_sock.setLoopbackMode(true);
                this.sock.setLoopbackMode(true);
            }
            this.mcast_addr = new IpAddress(this.mcast_group_addr, this.mcast_port);
            if (this.diag_handler.isEnabled() && this.diag_handler.getMcastAddress().equals(this.mcast_group_addr) && this.diag_handler.getPort() == this.mcast_port) {
                throw new IllegalArgumentException("diagnostics_addr:diagnostics_port and mcast_addr:mcast_port have to be different");
            }
            if (this.tos > 0) {
                try {
                    this.mcast_sock.setTrafficClass(this.tos);
                }
                catch (SocketException e) {
                    this.log.warn(Util.getMessage("TrafficClass"), this.tos, e);
                }
            }
            if (this.receive_on_all_interfaces || this.receive_interfaces != null && !this.receive_interfaces.isEmpty()) {
                List interfaces = this.receive_interfaces != null ? this.receive_interfaces : Util.getAllAvailableInterfaces();
                this.joinGroupOnInterfaces(interfaces, this.mcast_sock, this.mcast_addr.getIpAddress());
            } else {
                if (this.bind_addr != null) {
                    this.setNetworkInterface(this.bind_addr, this.mcast_sock);
                }
                this.mcast_sock.joinGroup(new InetSocketAddress(this.mcast_group_addr, this.mcast_port), this.bind_addr == null ? null : NetworkInterface.getByInetAddress(this.bind_addr));
            }
        }
        this.setBufferSizes();
        this.log.debug("socket information:\n%s", this.dumpSocketInfo());
    }

    protected void destroySockets() {
        this.closeMulticastSocket();
        this.closeUnicastSocket();
    }

    protected PacketReceiver[] createReceivers(int num, DatagramSocket sock, String name) {
        PacketReceiver[] receivers = new PacketReceiver[num];
        for (int i = 0; i < num; ++i) {
            receivers[i] = new PacketReceiver(sock, name);
        }
        return receivers;
    }

    protected IpAddress createLocalAddress() {
        if (this.sock == null || this.sock.isClosed()) {
            return null;
        }
        if (this.external_addr != null) {
            if (this.external_port > 0) {
                return new IpAddress(this.external_addr, this.external_port);
            }
            return new IpAddress(this.external_addr, this.sock.getLocalPort());
        }
        return new IpAddress(this.sock.getLocalAddress(), this.sock.getLocalPort());
    }

    protected <T extends UDP> T setTimeToLive(int ttl, MulticastSocket s) {
        try {
            if (s != null) {
                s.setTimeToLive(ttl);
            }
        }
        catch (Throwable ex) {
            this.log.error("failed setting ip_ttl to %d: %s", ttl, ex);
        }
        return (T)this;
    }

    protected <T extends UDP> T setNetworkInterface(InetAddress addr, MulticastSocket s) {
        NetworkInterface intf = null;
        try {
            if (s != null && addr != null) {
                intf = NetworkInterface.getByInetAddress(addr);
                s.setNetworkInterface(intf);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("multicast_socket on %s", intf.getName()));
                }
            }
        }
        catch (Throwable ex) {
            this.log.error("failed setting interface to %s (%s): %s", intf, addr, ex);
        }
        return (T)this;
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.createLocalAddress();
    }

    protected void joinGroupOnInterfaces(List<NetworkInterface> interfaces, MulticastSocket s, InetAddress mcast_addr) {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(mcast_addr, this.mcast_port);
        for (NetworkInterface intf : interfaces) {
            try {
                s.joinGroup(tmp_mcast_addr, intf);
                this.log.debug("joined %s on %s", tmp_mcast_addr, intf.getName());
            }
            catch (IOException e) {
                this.log.warn(Util.getMessage("InterfaceJoinFailed"), tmp_mcast_addr, intf.getName());
            }
        }
    }

    protected MulticastSocket createMulticastSocketWithBindPort() throws Exception {
        int rcv_port;
        MulticastSocket tmp = null;
        Exception saved_exception = null;
        int max_port = this.bind_port + this.port_range;
        for (rcv_port = this.bind_port; rcv_port <= max_port; ++rcv_port) {
            try {
                return this.createMulticastSocket("jgroups.udp.sock", rcv_port);
            }
            catch (SecurityException | SocketException bind_ex) {
                saved_exception = bind_ex;
                continue;
            }
        }
        if (rcv_port >= max_port + 1) {
            throw new Exception(String.format("failed to open a port in range %d-%d (last exception: %s)", this.bind_port, max_port, saved_exception));
        }
        return tmp;
    }

    protected MulticastSocket createMulticastSocket(String service_name, int port) throws Exception {
        MulticastSocket retval = this.getSocketFactory().createMulticastSocket(service_name, null);
        if (this.bind_addr != null) {
            this.setNetworkInterface(this.bind_addr, retval);
        }
        retval.setReuseAddress(false);
        retval.bind(new InetSocketAddress(this.bind_addr, port));
        return retval;
    }

    protected String dumpSocketInfo() throws Exception {
        String nic_name;
        StringBuilder sb = new StringBuilder(128);
        Formatter formatter = new Formatter(sb);
        formatter.format("mcast_addr=%s, bind_addr=%s, ttl=%d", this.mcast_addr, this.bind_addr, this.ip_ttl);
        if (this.sock != null) {
            formatter.format("\nsock: bound to %s:%d, receive buffer size=%d, send buffer size=%d", this.sock.getLocalAddress().getHostAddress(), this.sock.getLocalPort(), this.sock.getReceiveBufferSize(), this.sock.getSendBufferSize());
        }
        if (this.mcast_sock != null) {
            formatter.format("\nmcast_sock: bound to %s:%d, send buffer size=%d, receive buffer size=%d", this.mcast_sock.getLocalAddress(), this.mcast_sock.getLocalPort(), this.mcast_sock.getSendBufferSize(), this.mcast_sock.getReceiveBufferSize());
        }
        NetworkInterface nic = this.bind_addr != null ? NetworkInterface.getByInetAddress(this.bind_addr) : null;
        String string = nic_name = nic != null ? nic.getName() : "n/a";
        if (this.bind_port > 0) {
            formatter.format("\n%s: using network interface '%s' with port range '%s-%s'", this.bind_addr, nic_name, this.bind_port, this.bind_port + this.port_range);
        } else {
            formatter.format("\n%s: using network interface '%s' to any (ephemeral) port", this.bind_addr, nic_name);
        }
        return sb.toString();
    }

    void setBufferSizes() throws SocketException {
        if (this.sock != null) {
            this.setBufferSize(this.sock, this.ucast_send_buf_size, this.ucast_recv_buf_size);
            if (this.ucast_send_buf_size <= 0) {
                this.ucast_send_buf_size = UDP.getBufferSize(this.sock, true);
            }
            if (this.ucast_recv_buf_size <= 0) {
                this.ucast_recv_buf_size = UDP.getBufferSize(this.sock, false);
            }
        }
        if (this.mcast_sock != null) {
            this.setBufferSize(this.mcast_sock, this.mcast_send_buf_size, this.mcast_recv_buf_size);
            if (this.mcast_send_buf_size <= 0) {
                this.mcast_send_buf_size = UDP.getBufferSize(this.mcast_sock, true);
            }
            if (this.mcast_recv_buf_size <= 0) {
                this.mcast_recv_buf_size = UDP.getBufferSize(this.mcast_sock, false);
            }
        }
        int max_size = 65541;
        if (this.sock != null) {
            if (this.sock.getSendBufferSize() < max_size) {
                this.setCorrectSocketBufferSize(this.sock, this.sock.getSendBufferSize(), max_size, true, false);
            }
            if (this.sock.getReceiveBufferSize() < max_size) {
                this.setCorrectSocketBufferSize(this.sock, this.sock.getReceiveBufferSize(), max_size, false, false);
            }
        }
        if (this.mcast_sock != null) {
            if (this.mcast_sock.getSendBufferSize() < max_size) {
                this.setCorrectSocketBufferSize(this.mcast_sock, this.mcast_sock.getSendBufferSize(), max_size, true, true);
            }
            if (this.mcast_sock.getReceiveBufferSize() < max_size) {
                this.setCorrectSocketBufferSize(this.mcast_sock, this.mcast_sock.getReceiveBufferSize(), max_size, false, true);
            }
        }
    }

    protected void setBufferSize(DatagramSocket sock, int send_buf_size, int recv_buf_size) {
        int actual_size;
        if (send_buf_size > 0) {
            try {
                sock.setSendBufferSize(send_buf_size);
                actual_size = sock.getSendBufferSize();
                if (actual_size < send_buf_size && this.log.isWarnEnabled()) {
                    this.log.warn(Util.getMessage("IncorrectBufferSize"), "send", sock.getClass().getSimpleName(), Util.printBytes(send_buf_size), Util.printBytes(actual_size));
                }
            }
            catch (Throwable ex) {
                this.log.warn(Util.getMessage("BufferSizeFailed"), "send", send_buf_size, sock, ex);
            }
        }
        if (recv_buf_size > 0) {
            try {
                sock.setReceiveBufferSize(recv_buf_size);
                actual_size = sock.getReceiveBufferSize();
                if (actual_size < recv_buf_size && this.log.isWarnEnabled()) {
                    this.log.warn(Util.getMessage("IncorrectBufferSize"), "receive", sock.getClass().getSimpleName(), Util.printBytes(recv_buf_size), Util.printBytes(actual_size));
                }
            }
            catch (Throwable ex) {
                this.log.warn(Util.getMessage("BufferSizeFailed"), "receive", recv_buf_size, sock, ex);
            }
        }
    }

    protected static int getBufferSize(DatagramSocket s, boolean send) {
        try {
            return send ? s.getSendBufferSize() : s.getReceiveBufferSize();
        }
        catch (SocketException e) {
            return 0;
        }
    }

    void closeMulticastSocket() {
        if (this.mcast_sock != null) {
            try {
                if (this.mcast_addr != null) {
                    InetSocketAddress addr = new InetSocketAddress(this.mcast_addr.getIpAddress(), this.mcast_addr.getPort());
                    this.mcast_sock.leaveGroup(addr, this.bind_addr == null ? null : NetworkInterface.getByInetAddress(this.bind_addr));
                }
                this.getSocketFactory().close(this.mcast_sock);
                this.mcast_sock = null;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("%s: multicast socket closed", this.local_addr);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcast_addr = null;
        }
    }

    protected void closeUnicastSocket() {
        this.getSocketFactory().close(this.sock);
    }

    protected void startThreads() throws Exception {
        this.startUcastReceiverThreads();
        this.startMcastReceiverThreads();
    }

    protected void startUcastReceiverThreads() {
        if (this.ucast_receivers != null) {
            for (PacketReceiver r : this.ucast_receivers) {
                r.start();
            }
        }
    }

    protected void startMcastReceiverThreads() {
        if (this.mcast_receivers != null) {
            for (PacketReceiver r : this.mcast_receivers) {
                r.start();
            }
        }
    }

    protected void stopThreads() {
        this.stopMcastReceiverThreads();
        this.stopUcastReceiverThreads();
    }

    protected void stopUcastReceiverThreads() {
        Util.close(this.ucast_receivers);
    }

    protected void stopMcastReceiverThreads() {
        Util.close(this.mcast_receivers);
    }

    protected void handleConfigEvent(Map<String, Object> map) throws SocketException {
        boolean set_buffers = false;
        if (map == null) {
            return;
        }
        if (map.containsKey("send_buf_size")) {
            this.ucast_send_buf_size = this.mcast_send_buf_size = ((Integer)map.get("send_buf_size")).intValue();
            set_buffers = true;
        }
        if (map.containsKey("recv_buf_size")) {
            this.ucast_recv_buf_size = this.mcast_recv_buf_size = ((Integer)map.get("recv_buf_size")).intValue();
            set_buffers = true;
        }
        if (set_buffers) {
            this.setBufferSizes();
        }
    }

    public class PacketReceiver
    implements Runnable,
    Closeable {
        private Thread thread;
        private final DatagramSocket receiver_socket;
        private final String name;

        public PacketReceiver(DatagramSocket socket, String name) {
            this.receiver_socket = socket;
            this.name = name;
        }

        public synchronized void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = UDP.this.getThreadFactory().newThread(this, this.name);
                this.thread.start();
            }
        }

        @Override
        public void close() throws IOException {
            this.stop();
        }

        public synchronized void stop() {
            Thread tmp = this.thread;
            this.thread = null;
            if (tmp != null && tmp.isAlive()) {
                tmp.interrupt();
                try {
                    tmp.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void run() {
            byte[] receive_buf = new byte[66000];
            DatagramPacket packet = new DatagramPacket(receive_buf, receive_buf.length);
            while (Thread.currentThread().equals(this.thread)) {
                try {
                    if (is_android) {
                        packet.setLength(receive_buf.length);
                    }
                    this.receiver_socket.receive(packet);
                    int len = packet.getLength();
                    if (len > receive_buf.length && UDP.this.log.isErrorEnabled()) {
                        UDP.this.log.error(Util.getMessage("SizeOfTheReceivedPacket"), len, receive_buf.length, receive_buf.length);
                    }
                    UDP.this.receive(new IpAddress(packet.getAddress(), packet.getPort()), receive_buf, packet.getOffset(), len);
                }
                catch (SocketException sock_ex) {
                    if (this.receiver_socket.isClosed()) {
                        UDP.this.log.debug("%s: receiver socket is closed, exception=%s", UDP.this.local_addr, sock_ex.getMessage());
                        break;
                    }
                    UDP.this.log.error(Util.getMessage("FailedReceivingPacket"), sock_ex);
                }
                catch (Throwable ex) {
                    UDP.this.log.error(Util.getMessage("FailedReceivingPacket"), ex);
                }
            }
            if (UDP.this.log.isDebugEnabled()) {
                UDP.this.log.debug(this.name + " thread terminated");
            }
        }

        public String toString() {
            return this.receiver_socket != null ? this.receiver_socket.getLocalSocketAddress().toString() : "null";
        }
    }
}

