/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonp;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class AbstractJsonpProvider {
    @Context
    Providers providers;
    private static final JsonReaderFactory readerFactory = Json.createReaderFactory(null);
    private static final JsonWriterFactory writerFactory = Json.createWriterFactory(null);

    public static Charset getCharset(MediaType mediaType) {
        String charset;
        if (mediaType != null && (charset = (String)mediaType.getParameters().get("charset")) != null) {
            return Charset.forName(charset);
        }
        return null;
    }

    protected JsonReader findReader(MediaType mediaType, InputStream is) {
        Charset charset;
        ContextResolver resolver = this.providers.getContextResolver(JsonReaderFactory.class, mediaType);
        JsonReaderFactory factory = null;
        if (resolver != null) {
            factory = (JsonReaderFactory)resolver.getContext(JsonReaderFactory.class);
        }
        if (factory == null) {
            factory = readerFactory;
        }
        return (charset = AbstractJsonpProvider.getCharset(mediaType)) == null ? factory.createReader(is) : factory.createReader(is, charset);
    }

    protected JsonWriter findWriter(MediaType mediaType, OutputStream os) {
        Charset charset;
        ContextResolver resolver = this.providers.getContextResolver(JsonWriterFactory.class, mediaType);
        JsonWriterFactory factory = null;
        if (resolver != null) {
            factory = (JsonWriterFactory)resolver.getContext(JsonWriterFactory.class);
        }
        if (factory == null) {
            factory = writerFactory;
        }
        return (charset = AbstractJsonpProvider.getCharset(mediaType)) == null ? factory.createWriter(os) : factory.createWriter(os, charset);
    }
}

